###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for libkonq

if( WITH_KONQUEROR )
  find_file( HAVE_LIBKONQ "konq_popupmenu.h" "konqbookmarkmanager.h" )
  if( NOT HAVE_LIBKONQ )
    tde_message_fatal( "libkonq was requested, but not found on your system" )
  endif( )
endif( )


##### check for javascript

if( WITH_JAVASCRIPT )
  find_file( HAVE_JAVASCRIPT "kjsembed/kjsembedpart.h" )
  if( NOT HAVE_JAVASCRIPT )
    tde_message_fatal( "Embedded Javascript interpreter was requested, but not found on your system" )
  endif( )
endif( )


##### check for ACL

if( WITH_ACL )
  pkg_search_module( ACL libacl )
  if( NOT ACL_FOUND )
    find_file( HAVE_ACL_H "sys/acl.h" )
    if( HAVE_ACL_H )
      find_library( HAVE_ACL_LIB NAMES acl )
      if( HAVE_ACL_LIB )
        set( ACL_LIBRARIES "${HAVE_ACL_LIB}" CACHE INTERNAL "Extended ACL library" FORCE )
      endif( )
      tde_save_and_set( CMAKE_REQUIRED_LIBRARIES "${ACL_LIBRARIES}" )
      check_symbol_exists( acl_free "${HAVE_ACL_H}" HAVE_ACL )
      tde_restore( CMAKE_REQUIRED_LIBRARIES )
      if( HAVE_ACL )
        set( ACL_FOUND 1 CACHE INTERNAL "Posix ACL found" FORCE )
      endif()
    endif()
  endif( )
  if( NOT ACL_FOUND )
    tde_message_fatal( "ACL support was requested, but not found on your system" )
  endif( )
  set( HAVE_POSIX_ACL 1 )
  find_file( HAVE_NON_POSIX_ACL_EXT "acl/libacl.h" )
endif( )
