/*
	mtip.h - A tip widget
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MTIP_H__
#define __MTIP_H__

#include <kactivelabel.h>

/** @short A tip widget based on the @c KActiveLabel widget. */
class MTip: public KActiveLabel
{
public:
	/**
	 * Tip types.
	 */
	enum TipType {
		Info, /**< Info tip. */
		Normal, /**< Normal tip. */
		Warning /**< Warning tip. */
	};

	/**
	 * Constructor.
	 * @param tipType A tip type
	 * @param parent A parent widget
	 */
	MTip(const TipType tipType, TQWidget *parent);

	/**
	 * Destructor.
	 */
	virtual ~MTip();

	/**
	 * Sets tip text to @p value.
	 */
	void setTipText(const TQString &value);

	/**
	 * Sets tip type to @p value.
	 */
	void setTipType(const TipType value);
private:
	TQString _iconPath;
	TipType _type;
	TQString getIconPath(const TQString &name) const;
};

#endif // __MTIP_H__
