#ifndef _KVI_DIALOG_H_
#define _KVI_DIALOG_H_
//=============================================================================
//
//   File : libkvidialog.cpp
//   Creation date : Sat Sep 15 2001 01:13:25 by Szymon Stefanek
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_parameterlist.h"
#include "kvi_filedialog.h"
#include "kvi_imagedialog.h"

#include "kvi_kvs_callbackobject.h"

#include <tqmessagebox.h>
#include <tqdialog.h>



// New KVS
class KviKvsCallbackMessageBox : public TQMessageBox, public KviKvsCallbackObject
{
	TQ_OBJECT
  
public:
	KviKvsCallbackMessageBox(
		const TQString &szCaption,
		const TQString &szText,
		const TQString &szIcon,
		const TQString &szButton0,
		const TQString &szButton1,
		const TQString &szButton2,
		const TQString &szCode,
		KviKvsVariantList * pMagicParams,
		KviWindow * pWindow, bool modal=false);
	~KviKvsCallbackMessageBox();
protected slots:
	virtual void done(int code);
};




// New KVS
class KviKvsCallbackTextInput : public TQDialog, public KviKvsCallbackObject
{
	TQ_OBJECT
  
public:
	KviKvsCallbackTextInput(
		const TQString &szCaption,
		const TQString &szLabel,
		const TQString &szDefaultText,
		const TQString &szIcon,
		bool bMultiLine,
		const TQString &szButton0,
		const TQString &szButton1,
		const TQString &szButton2,
		const TQString &szCode,
		KviKvsVariantList * pMagicParams,
		KviWindow * pWindow, bool modal=false);
	~KviKvsCallbackTextInput();
protected:
	bool      m_bMultiLine;
	TQWidget * m_pEdit;
	int       m_iEscapeButton;
	int       m_iDefaultButton;
protected:
	virtual void closeEvent(TQCloseEvent *e);
	virtual void showEvent(TQShowEvent *e);
protected slots:
	void b0Clicked();
	void b1Clicked();
	void b2Clicked();
	virtual void done(int code);
};



// New KVS
class KviKvsCallbackFileDialog : public KviFileDialog, public KviKvsCallbackObject
{
	TQ_OBJECT
  
public:
	KviKvsCallbackFileDialog(
		const TQString &szCaption,
		const TQString &szInitialSelection,
		const TQString &szFilter,
		const TQString &szCode,
		KviKvsVariantList * pMagicParams,
		KviWindow * pWindow, bool modal=false);
	~KviKvsCallbackFileDialog();
protected:
	virtual void done(int code);
};


// New KVS
class KviKvsCallbackImageDialog : public KviImageDialog, public KviKvsCallbackObject
{
	TQ_OBJECT
  
public:
	KviKvsCallbackImageDialog(
		const TQString &szCaption,
		const TQString &szInitialSelection,
		int iType,
		int iMaxSize,
		const TQString &szCode,
		KviKvsVariantList * pMagicParams,
		KviWindow * pWindow,bool modal=false);
	~KviKvsCallbackImageDialog();
protected:
	virtual void done(int code);
};

#endif //_KVI_DIALOG_H_
