BEGIN { print "1..6\n" }

package MyApp;
use TQt;
use TQt::isa('TQt::Application');
use TQt::slots
        foo => ['int'],
        baz => [];
use TQt::signals
        bar => ['int'];

sub NEW
{
     shift->SUPER::NEW(@_);
     this->connect(this, TQ_SIGNAL 'bar(int)', TQ_SLOT 'foo(int)');
     this->connect(this, TQ_SIGNAL 'aboutToQuit()', TQ_SLOT 'baz()');
}

sub foo
{
    # 1) testing correct inheritance of sig/slots
    print +($_[0] == 3) ? "ok 1\n" : "not ok\n";
}

sub baz
{
    print "ok 3\n";
}     

sub coincoin
{
    print +(@_ == 2) ? "ok 5\n":"not ok\n";
    print +(ref(this) eq " MySubApp") ? "ok 6\n":"not ok\n";
}

1;

package MySubApp;
use TQt;
use TQt::isa('MyApp');


sub NEW 
{
    shift->SUPER::NEW(@_);
    emit foo(3);
}

sub baz
{
   # 2) testing further inheritance of sig/slots
   print "ok 2\n";
   # 3) testing Perl to Perl SUPER
   SUPER->baz();
   # 4) 5) 6) testing non-qualified enum calls vs. Perl method/static calls
   eval { &blue }; print !$@ ? "ok 4\n":"not ok\n";
   coincoin("a","b");
}

1;

package main;

use TQt;
use MySubApp;

$a = 0;
$a = MySubApp(\@ARGV);

TQt::Timer::singleShot( 300, TQt::app(), TQ_SLOT "quit()" );

exit TQt::app()->exec;
