
#include <tqstring.h>

#include "core/polkit-tqt-authority.h"
#include "core/polkit-tqt-details.h"

#define TEST_PASSED 0
#define TEST_FAILED 1

using namespace PolkitTQt;

void wait()
{
  for (int i = 0; i < 100; i++)
  {
    usleep(100);
  }
}

int main(void)
{
  // This needs the file org.tqt.policykit.examples.policy from examples to be installed
  ActionDescription::List list = Authority::instance()->enumerateActionsSync();
  if (Authority::instance()->hasError())
  {
    return TEST_FAILED;
  }
  // Check whether enumerateAction returns at least example actions
  int count = 0;
  for (const ActionDescription &actionDesc : list)
  {
    if ((actionDesc.actionId() == "org.tqt.policykit.examples.kick") ||
        (actionDesc.actionId() == "org.tqt.policykit.examples.cry") ||
        (actionDesc.actionId() == "org.tqt.policykit.examples.bleed"))
    {
      count++;
    }
  }
  if (count != 3)
  {
    return TEST_FAILED;
  }

  // Test cancelling the enumeration
  Authority::instance()->enumerateActions();
  Authority::instance()->enumerateActionsCancel();
  wait();
  if (Authority::instance()->hasError())
  {
    return TEST_FAILED;
  }

  return TEST_PASSED;
}
