import os, time

from PyTQt.tqt import TQImage, TQLabel, TQPixmap, TQPushButton, TQ_SIGNAL, TQColor, TQValidator

from tdeui import KMessageBox, KDateValidator, KFloatValidator, KIntValidator, KLineEdit, KLed



class Page3:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 15

        green  = TQColor (0, 255, 0)
        yellow = TQColor (255, 255, 0)
        red    = TQColor (255, 0, 0)

        ivLbl  = TQLabel ("KIntValidator", self.page)
        ivLbl.setGeometry (x, y, 100, 20)
        ivLbl.show ()

        self.iv = KLineEdit (self.page)
        self.iv.setGeometry (x, y + 20, 100, 20)
        self.iv.show ()
        self.page.connect (self.iv, TQ_SIGNAL("textChanged (const TQString &)"), self.ivChanged)

        self.ivVal = KIntValidator (self.page)
        self.ivVal.setRange (20, 50)

        ivRngLbl = TQLabel ("Range is 20 - 50", self.page)
        ivRngLbl.setGeometry (x, y + 45, 100, 20)
        ivRngLbl.show ()

        ivAccLbl   = TQLabel ("Acceptable", self.page)
        ivAccLbl.setGeometry (x + 125, y + 45, 85, 20)
        ivAccLbl.show ()
        ivInterLbl = TQLabel ("Intermediate", self.page)
        ivInterLbl.setGeometry (x + 125, y + 20, 85, 20)
        ivInterLbl.show ()
        ivInvalLbl = TQLabel ("Invalid", self.page)
        ivInvalLbl.setGeometry (x + 125, y - 5, 85, 20)
        ivInvalLbl.show ()
        self.ivInvalLed = KLed (red, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.ivInvalLed.setGeometry (x + 215, y - 5, 18, 18)
        self.ivInvalLed.show ()
        self.ivInterLed = KLed (yellow, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.ivInterLed.setGeometry (x + 215, y + 20, 18, 18)
        self.ivInterLed.show ()
        self.ivAccLed = KLed (green, KLed.On, KLed.Sunken, KLed.Circular,self.page)
        self.ivAccLed.setGeometry (x + 215, y + 45, 18, 18)
        self.ivAccLed.show ()

        y = y + 100

        fvLbl  = TQLabel ("KFloatValidator", self.page)
        fvLbl.setGeometry (x, y, 100, 20)
        fvLbl.show ()

        self.fv = KLineEdit (self.page)
        self.fv.setGeometry (x, y + 20, 100, 20)
        self.fv.show ()
        self.page.connect (self.fv, TQ_SIGNAL("textChanged (const TQString &)"), self.fvChanged)

        self.fvVal = KFloatValidator (self.page)
        self.fvVal.setRange (10.0, 40.0)

        fvRngLbl = TQLabel ("Range is 10.0 - 40.0", self.page)
        fvRngLbl.setGeometry (x, y + 45, 100, 20)
        fvRngLbl.show ()

        fvAccLbl   = TQLabel ("Acceptable", self.page)
        fvAccLbl.setGeometry (x + 125, y + 45, 85, 20)
        fvAccLbl.show ()
        fvInterLbl = TQLabel ("Intermediate", self.page)
        fvInterLbl.setGeometry (x + 125, y + 20, 95, 20)
        fvInterLbl.show ()
        fvInvalLbl = TQLabel ("Invalid", self.page)
        fvInvalLbl.setGeometry (x + 125, y - 5, 85, 20)
        fvInvalLbl.show ()
        self.fvInvalLed = KLed (red, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.fvInvalLed.setGeometry (x + 215, y - 5, 18, 18)
        self.fvInvalLed.show ()
        self.fvInterLed = KLed (yellow, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.fvInterLed.setGeometry (x + 215, y + 20, 18, 18)
        self.fvInterLed.show ()
        self.fvAccLed = KLed (green, KLed.On, KLed.Sunken, KLed.Circular,self.page)
        self.fvAccLed.setGeometry (x + 215, y + 45, 18, 18)
        self.fvAccLed.show ()

        y = y + 100

        dvLbl  = TQLabel ("KDateValidator", self.page)
        dvLbl.setGeometry (x, y, 100, 20)
        dvLbl.show ()

        self.dv = KLineEdit (self.page)
        self.dv.setGeometry (x, y + 20, 100, 20)
        self.dv.show ()
#        self.page.connect (self.dv, TQ_SIGNAL("textChanged (const TQString &)"), self.dvChanged)

        self.dvVal = KDateValidator (self.page)
#        self.dvVal.setRange (10.0, 40.0)

#        dvRngLbl = TQLabel ("Range is 10.0 - 40.0", self.page)
#        dvRngLbl.setGeometry (x, y + 45, 100, 20)
#        dvRngLbl.show ()

        dvBtn = TQPushButton ("Validate", self.page)
        dvBtn.setGeometry (x, y + 45, 60, 22)
        dvBtn.show ()
        self.page.connect (dvBtn, TQ_SIGNAL ("clicked ()"), self.dvChanged)

        dvNoteLbl = TQLabel ("Format is locale dependent\nShort date only\nTry DD-MM-YY", self.page)
        dvNoteLbl.setGeometry (x, y + 70, 150, 60)
        dvNoteLbl.show ()

        dvAccLbl   = TQLabel ("Acceptable", self.page)
        dvAccLbl.setGeometry (x + 125, y + 45, 85, 20)
        dvAccLbl.show ()
        dvInterLbl = TQLabel ("Intermediate", self.page)
        dvInterLbl.setGeometry (x + 125, y + 20, 85, 20)
        dvInterLbl.show ()
        dvInvalLbl = TQLabel ("Invalid", self.page)
        dvInvalLbl.setGeometry (x + 125, y - 5, 85, 20)
        dvInvalLbl.show ()
        self.dvInvalLed = KLed (red, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.dvInvalLed.setGeometry (x + 215, y - 5, 18, 18)
        self.dvInvalLed.show ()
        self.dvInterLed = KLed (yellow, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.dvInterLed.setGeometry (x + 215, y + 20, 18, 18)
        self.dvInterLed.show ()
        self.dvAccLed = KLed (green, KLed.On, KLed.Sunken, KLed.Circular,self.page)
        self.dvAccLed.setGeometry (x + 215, y + 45, 18, 18)
        self.dvAccLed.show ()

    def ivChanged (self):
        self.ivInvalLed.off ()
        self.ivInterLed.off ()
        self.ivAccLed.off ()

        state, i = self.ivVal.validate (self.iv.text ())

        if state == TQValidator.Acceptable:
            self.ivAccLed.on ()
        elif state == TQValidator.Intermediate:
            self.ivInterLed.on ()
        else:
            self.ivInvalLed.on ()

    def fvChanged (self):
        self.fvInvalLed.off ()
        self.fvInterLed.off ()
        self.fvAccLed.off ()

        state, i = self.fvVal.validate (self.fv.text ())

        if state == TQValidator.Acceptable:
            self.fvAccLed.on ()
        elif state == TQValidator.Intermediate:
            self.fvInterLed.on ()
        else:
            self.fvInvalLed.on ()

    def dvChanged (self):
        self.dvInvalLed.off ()
        self.dvInterLed.off ()
        self.dvAccLed.off ()

        state, i = self.dvVal.validate (self.dv.text ())

        if state == TQValidator.Acceptable:
            self.dvAccLed.on ()
        elif state == TQValidator.Intermediate:
            self.dvInterLed.on ()
        else:
            self.dvInvalLed.on ()

class PageNotImpl:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        niLbl   = TQLabel ("Nothing is currently implemented for this widget", self.page)
        niLbl.setGeometry (x, y, 300, 20)
        niLbl.show ()

def miscKAlphaPainter (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscTDECModule (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKColor (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKColorDrag (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKCommand (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKCommandHistory (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKDockWindow (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKFloatValidator (parent):
    parent.currentPageObj = Page3 (parent)

def miscKDateValidator (parent):
    parent.currentPageObj = Page3 (parent)

def miscKIntValidator (parent):
    parent.currentPageObj = Page3 (parent)

def miscKPixmapIO (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscTDESharedPixmap (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKSystemTray (parent):
    KMessageBox.information (parent, "See the systray.py example in the templates/ subdirectories")

def miscKThemeBase (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscQXEmbed (parent):
    parent.currentPageObj = PageNotImpl (parent)

if __name__ == "__main__":
    print()
    print("Please run uisampler.py")
    print()
