#!/usr/bin/env perl

use strict;
use warnings;

# Get real cmake version and package version prefix
my $version = `cmake --version | awk '/^cmake version/ {print \$3}' | tr -d '\n'`;
my $packageversion = `dpkg-query -W -f='\${Version}' cmake`;
my ($prefix);
my ($version3, $version3_next);
my ($version2, $version2_next);

($prefix = $packageversion) =~ s/$version.*//;
($version3 = $version)  =~ s/^(([^.]+\.){2}[^.+~-]+)[.+~-]?[^-]*-[^-]+$/$1/;
($version2 = $version3) =~ s/\.[^.]+$//;

($version3_next = $version3) =~ s/(?<=\.)(\d+)[a-z]?$/($1+1)/e;
($version2_next = $version2) =~ s/(?<=\.)(\d+)$/($1+1)/e;

print "CMake-Version3=$prefix$version3\n";
print "CMake-Version2=$prefix$version2\n";
print "CMake-Next-Version3=$prefix$version3_next\n";
print "CMake-Next-Version2=$prefix$version2_next\n";
