/*
   Copyright (C) 2000, 2001, 2002 Dawit Alemayehu <adawit@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef __RSYNC_PLUGIN_H
#define __RSYNC_PLUGIN_H

#include <tqmap.h>
#include <tqstringlist.h>

#include <kurl.h>
#include <tdeprocess.h>
#include <tdefileitem.h>
#include <klibloader.h>
#include <tdeparts/plugin.h>
#include <tdeio/global.h>
#include <tdeio/slavebase.h>

#include <libtdersync/tdersync.h>

// NOTE: If ANY of these functions are not utilized in the C file,
// and in a manner identical to these declarations, the plugin will
// mysteriously fail when launched with kshell but work fine under BASH

class TDEActionMenu;
class KonqDirPart;
class KLineEdit;

namespace KParts
{
  struct URLArgs;
}

class RsyncPlugin : public KParts::Plugin
{
  TQ_OBJECT
  

public:

  RsyncPlugin (TQObject* parent, const char* name, const TQStringList &);
  virtual ~RsyncPlugin();

private slots:
  void slotSync();
  void slotSetup();
  void slotOpenURL();
  void slotSetupDone();
  void slotTransferDone();

private:
  KURL m_pURL;
  KonqDirPart* m_part;
  TDEAction* m_pSyncNow;
  TDEAction* m_pSyncSetup;
  KRsync* m_rSync;
};
#endif
