/* This file is part of the KDE project
   Copyright (C) 2001 Holger Freyther <freyther@yahoo.com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "kuick_plugin.h"
#include "kuick_plugin.moc"
#include "kdirmenu.h"

#include <tdeapplication.h>
#include <tdeaction.h>
#include <tdeinstance.h>
#include <kiconloader.h>
#include <tdeimproxy.h>
#include <tdelocale.h>
#include <konq_popupmenu.h>
#include <tdemessagebox.h>
#include <kgenericfactory.h>
#include <tqobject.h>
#include <tdeio/jobclasses.h>
#include <tdeio/job.h>
#include <kurl.h>

typedef KGenericFactory<KTestMenu, KonqPopupMenu> KTestMenuFactory;
K_EXPORT_COMPONENT_FACTORY( libkuickplugin, KTestMenuFactory("kuick_plugin") )

KTestMenu::KTestMenu( KonqPopupMenu *popupmenu, const char *name, const TQStringList& /*list*/ ) : KonqPopupMenuPlugin( popupmenu, name) {
    popup= popupmenu ;
    meta_copy_mmu = 0L;
    meta_move_mmu = 0L;
    my_action = new TDEAction( "kuick_plugin", 0, this, TQ_SLOT( slotPopupMaeh( ) ), actionCollection( ), "Do some funky stuff"  );
    addAction( my_action );
    addSeparator();
    //popupmenu->addMerge();
    connect( popup, TQ_SIGNAL(aboutToShow() ), this, TQ_SLOT(slotPrepareMenu( ) ) );
    m_imProxy = KIMProxy::instance( tdeApp->dcopClient() );
}
KTestMenu::~KTestMenu( ){
     delete meta_copy_mmu;
     delete meta_move_mmu;
}
void KTestMenu::slotPopupMaeh( ){

}
void KTestMenu::slotStartCopyJob( const TQString &path ) {
     KURL url = KURL::fromPathOrURL( path );
     TDEIO::CopyJob *copy;
     copy = TDEIO::copy( popup->popupURLList(), url);
     copy->setAutoErrorHandlingEnabled( true );
}
void KTestMenu::slotStartMoveJob( const TQString &path) {
     KURL url = KURL::fromPathOrURL( path );
     TDEIO::CopyJob *move;
     move = TDEIO::move( popup->popupURLList(), url );
     move->setAutoErrorHandlingEnabled( true );
}

void KTestMenu::slotFileTransfer( const TQString &uid ) {
    m_imProxy->sendFile( uid, popup->popupURLList().first() );
}

void KTestMenu::slotPrepareMenu( ) { // now it's time to set up the menu...
// search for the dummy entry 'kuick_plugin' stores it index reomev it plug copy at the position
  TDEGlobal::locale()->insertCatalogue("kuick_plugin");

  bool isKDesktop = TQCString(  tdeApp->name() ) == "kdesktop";

  for(int i= popup->count(); i >=1; i--) {
    int id = popup->idAt( i );
    TQString text = popup->text( id );
    if( text.contains("kuick_plugin") ) {
      popup->removeItem( id );
      if (isKDesktop && !tdeApp->authorize("editable_desktop_icons"))
      {
         // Remove seperator as well
         id = popup->idAt( i-1 );
         if (popup->text( id ).isEmpty())
            popup->removeItem( id );
         break;
      }
      meta_copy_mmu = new KMetaMenu(popup, popup->url(),
              i18n("&Copy Here") , "kuick-copy", m_imProxy );
      popup->insertItem(i18n("Copy To"), meta_copy_mmu, -1, i   );
      connect( meta_copy_mmu, TQ_SIGNAL(fileChosen(const TQString &) ), 
          TQ_SLOT(slotStartCopyJob(const TQString & )) );
      
      connect( meta_copy_mmu, TQ_SIGNAL( contactChosen( const TQString & ) ),
          TQ_SLOT( slotFileTransfer( const TQString & )) );
          
      if( popup->protocolInfo().supportsMoving() ){
        meta_move_mmu = new KMetaMenu(popup, popup->url(),
              i18n("&Move Here"), "kuick-move");
        popup->insertItem(i18n("Move To"), meta_move_mmu, -1, i+1 );
        connect( meta_move_mmu, TQ_SIGNAL(fileChosen(const TQString &) ), 
            TQ_SLOT(slotStartMoveJob(const TQString & )) );
      }
      break;
    }
  }
}
