/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
// Author: Damyan Pepper
//         Toivo Pedaste
//
// See kpackage.h for more information.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/


#include "../config.h"

#include <tqdir.h>
#include <tqlabel.h>
#include <tqframe.h>

#include <kdebug.h>
#include <tdeapplication.h>
#include <tdefiledialog.h>
#include <kprogress.h>
#include <kurl.h>
#include <tdeapplication.h>
#include <tdeaccel.h>
#include <tdeaction.h>
#include <tdelocale.h>
#include <kinputdialog.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <kstdaction.h>
#include <kedittoolbar.h>
#include <kmimemagic.h>
#include <kurldrag.h>

#include "kpackage.h"
#include "managementWidget.h"
#include "pkgOptions.h"
#include "tdeio.h"
#include "findf.h"
#include "search.h"
#include "options.h"
#include "cache.h"

extern Opts *opts;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
KPKG::KPKG(TDEConfig *_config)
  : TDEMainWindow(0)
{
  kpackage = new KPACKAGE(_config, this);
  setCentralWidget(kpackage);

  config =  tdeApp->config();
  config->setGroup("Kpackage");

  kpackage->management->readPSeparator();

  // Get a nice default size
  resize(760,540);

  setupMenu();
  disableNext();
  disablePrevious();

  optiondialog = new Options(this);

  prop_restart = false;
  setAutoSaveSettings();
}

// Set up the menu

void KPKG::setupMenu()
{

  pack_open = KStdAction::open(kpackage, TQ_SLOT(fileOpen()),
			       actionCollection());

  recent = KStdAction::openRecent(this, TQ_SLOT(openRecent(const KURL&)),
				  actionCollection());
  recent->loadEntries( config );

  pack_find = new TDEAction( i18n("Find &Package..."), "edit-find",
			   TDEStdAccel::shortcut(TDEStdAccel::Find), kpackage,
			   TQ_SLOT(find()), actionCollection(), "pack_find");

  pack_findf = new TDEAction( i18n("Find &File..."), "filefind",
			    0, kpackage,
			    TQ_SLOT(findf()), actionCollection(), "pack_findf");

  kpack_reload = new TDEAction( i18n("&Reload"), "reload",
			      TDEStdAccel::shortcut(TDEStdAccel::Reload), kpackage,
			      TQ_SLOT(reload()), actionCollection(), "kpack_reload");

  (void) KStdAction::quit(kpackage, TQ_SLOT(fileQuit()),
			  actionCollection());

  pack_prev = KStdAction::back(kpackage->management->treeList, TQ_SLOT(previous()),
			       actionCollection(),"pack_prev");

  pack_next = KStdAction::forward(kpackage->management->treeList, TQ_SLOT(next()),
				  actionCollection(),"pack_next");

  (void) (new TDEAction( i18n("&Expand Tree"), "ftout",
		       0, kpackage,
		       TQ_SLOT(expandTree()), actionCollection(), "kpack_expand"));

  (void) (new TDEAction( i18n("&Collapse Tree"), "ftin",
		       0, kpackage,
		       TQ_SLOT(collapseTree()), actionCollection(), "kpack_collapse"));

  (void) (new TDEAction( i18n("Clear &Marked"), TQString(),
		       0, kpackage,
		       TQ_SLOT(clearMarked()), actionCollection(), "kpack_clear"));

  (void) (new TDEAction( i18n("Mark &All"), TQString(),
		       0, kpackage,
		       TQ_SLOT(markAll()), actionCollection(), "kpack_markall"));

  pack_install = new TDEAction( i18n("&Install"), TQString(),
			      0, kpackage->management,
			      TQ_SLOT(installSingleClicked()), actionCollection(), "install_single");

  pack_install->setEnabled(false);
  kpackage->management->setInstallAction(pack_install);


  pack_uninstall = new TDEAction( i18n("&Uninstall"), TQString(),
				0, kpackage->management,
				TQ_SLOT(uninstallSingleClicked()), actionCollection(), "uninstall_single");

  pack_uninstall->setEnabled(false);
  kpackage->management->setUninstallAction(pack_uninstall);


  (void) (new TDEAction( i18n("&Install Marked"), TQString(),
		       0, kpackage->management,
		       TQ_SLOT(installMultClicked()), actionCollection(), "install_marked"));

  (void) (new TDEAction( i18n("&Uninstall Marked"), TQString(),
		       0, kpackage->management,
		       TQ_SLOT(uninstallMultClicked()), actionCollection(), "uninstall_marked"));

  setStandardToolBarMenuEnabled(true);

  KStdAction::configureToolbars( this, TQ_SLOT(configureToolBars()),
				 actionCollection());

  KStdAction::saveOptions( this, TQ_SLOT(saveSettings()), actionCollection());

  KStdAction::keyBindings( guiFactory(), TQ_SLOT(configureShortcuts()), actionCollection());

  (void) (new TDEAction( i18n("Configure &KPackage..."), "configure",
		       0, this,
		       TQ_SLOT(setOptions()), actionCollection(), "kpack_options"));

  (void) (new TDEAction( i18n("Clear Package &Folder Cache"), TQString(),
		       0, this,
		       TQ_SLOT(clearDCache()), actionCollection(), "clear_dcache"));

  (void) (new TDEAction( i18n("Clear &Package Cache"), TQString(),
		       0, this,
		       TQ_SLOT(clearPCache()), actionCollection(), "clear_pcache"));

  int i;
  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
      kpinterface[i]->makeMenu(actionCollection());
    }
  }

  //  urlList.setAutoDelete(TRUE);
  createGUI();
}

void KPKG::disableMenu()
{
  pack_open->setEnabled(false);
  pack_find->setEnabled(false);
  pack_findf->setEnabled(false);
  kpack_reload->setEnabled(false);
  recent->setEnabled(false);
}

void KPKG::enableMenu()
{
  pack_open->setEnabled(true);
  pack_find->setEnabled(true);
  pack_findf->setEnabled(true);
  kpack_reload->setEnabled(true);
  recent->setEnabled(true);
}

void KPKG::disableNext() {
  pack_next->setEnabled(false);
}

void KPKG::enableNext() {
  pack_next->setEnabled(true);
}

void KPKG::disablePrevious() {
  pack_prev->setEnabled(false);
}

void KPKG::enablePrevious() {
  pack_prev->setEnabled(true);
}
void KPKG::openRecent(const KURL& url){
  kpackage->openNetFile( url );
}

void KPKG::add_recent_file(const TQString &newfile){

  KURL url = KURL(newfile);

  recent->addURL( url );
}

void KPKG::configureToolBars() {
  KEditToolbar dlg(actionCollection());
  connect(&dlg,TQ_SIGNAL(newToolbarConfig()),this,TQ_SLOT(slotNewToolbarConfig()));
  dlg.exec();
}

void KPKG::slotNewToolbarConfig() {
  createGUI();
}

void KPKG::writeSettings(){

  kpackage->management->writePSeparator();

  TDEConfig *config = tdeApp->config();

  config->setGroup("Kpackage");

  recent->saveEntries( config );

  kpackage->management->treeList->writeTreeConfig();
  kpackage->management->treeList->writeTreeType();

  config->sync();
}

void KPKG::setOptions(){
  optiondialog->restore();
}

void KPKG::saveSettings(){
  writeSettings();
}

void KPKG::clearPCache(){
  cacheObj::clearPCache();
}

void KPKG::clearDCache(){
  cacheObj::clearDCache();
}

void KPKG::saveProperties(TDEConfig *config )
{
    config->writePathEntry("Name", kpackage->save_url.url());
}


void KPKG::readProperties(TDEConfig *config)
{
    TQString entry = config->readPathEntry("Name"); // no default
    if (entry.isNull())
	return;
    kpackage->openNetFiles(entry);
    prop_restart = true;
}

bool KPKG::queryClose() {
    kpackage->cleanUp();
    return true;
} 

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

KPACKAGE::KPACKAGE(TDEConfig *_config, TQWidget *parent)
  : TQWidget(parent)
{

  // Save copy of config
  config = _config;

  setAcceptDrops(true);
  setupModeWidgets();

  setupStatusBar();

  file_dialog = NULL;
  findialog = NULL;
  srchdialog = NULL;

}

// Destructor
KPACKAGE::~KPACKAGE()
{
  //  destroyModeWidgets();
  //  delete status;
  //  delete processProgress;
}

// resize event -- arrange the widgets
void KPACKAGE::resizeEvent(TQResizeEvent *re)
{
  re = re;			// prevent warning
  arrangeWidgets();
}

// Set up the mode widgets
void KPACKAGE::setupModeWidgets()
{
  management = new managementWidget(this);

  for (int i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
      kpinterface[i]->uninstallation = new pkgOptionsU(kpinterface[i]);
      kpinterface[i]->installation = new pkgOptionsI(kpinterface[i]);
    }
  }
}

// destroy the mode widgets
void KPACKAGE::destroyModeWidgets()
{
  //  delete management;
  //  for (int i = 0; i < kpinterfaceN; i++) {
  //    if (kpinterface[i]) {
  //      delete kpinterface[i]->installation;
  //      delete kpinterface[i]->uninstallation;
  //    }
  //  }
}


// Set up the status bar
void KPACKAGE::setupStatusBar()
{
  statusbar = new TQFrame(this);
  statusbar->setFrameStyle(TQFrame::Raised | TQFrame::Panel);
  processProgress = new KProgress(100,statusbar);
  processProgress->setTextEnabled(FALSE);

  status = new TQLabel(i18n("Management Mode"), statusbar);
}

// Arrange the widgets nicely
void KPACKAGE::arrangeWidgets()
{
  int i;

  statusbar->resize(width(),20);
  statusbar->move(0,height()-20);
  status->resize((statusbar->width() / 4) * 3, 16);
  status->move(2,2);
  processProgress->resize(statusbar->width() / 4 - 4, 16);
  processProgress->move((statusbar->width() / 4) * 3 + 3, 2);

  management->resize(width(),height() - 20);

  for (i = 0; i < kpinterfaceN; i++)
    if (kpinterface[i]) {
      kpinterface[i]->installation->resize(width(),height() - 20);
    }
}

void KPACKAGE::setup()
{
  management->collectData(1);
}

void KPACKAGE::fileQuit()		// file->quit selected from menu
{
  cleanUp();

  TDEApplication::exit(0);	// exit the application
}

void KPACKAGE::cleanUp()		// file->quit selected from menu
{
  kpkg->writeSettings();
  if (opts->DCache >= Opts::SESSION) {
    cacheObj::clearDCache(); // clear dir caches if needed
  }
  if (opts->PCache >= Opts::SESSION) {
    cacheObj::clearPCache(); // clear package caches if needed
  }
}

void KPACKAGE::reload()
{
  kpackage->management->collectData(TRUE);
}

void KPACKAGE::fileOpen()		// file->quit selected from menu
{
    KFileDialog *box;

    box = getFileDialog(i18n("Select Package"));

    if( box->exec())
    {
        if(!box->selectedURL().isEmpty())
        {
            openNetFile( box->selectedURL() );
        }
    }
}

void KPACKAGE::clearMarked()
{
  management->treeList->clearMarked(management->treeList->firstChild());
}

void KPACKAGE::markAll()
{
  management->treeList->markAll(management->treeList->firstChild());
}

void KPACKAGE::expandTree()
{
  management->treeList->expandTree(management->treeList);
}

void KPACKAGE::collapseTree()
{
  management->treeList->collapseTree(management->treeList);
}

pkgInterface *KPACKAGE::pkType(const TQString &fname)
{
  // Get the package information for this package
  char buf[51];
  int i;

  FILE *file= fopen(TQFile::encodeName(fname),"r");
  if (file) {
    fgets(buf,sizeof(buf)-1,file);
    buf[50] = 0;

    // check enabled package handlers
    for (i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i]) {
	if (opts->handlePackage[i] && kpinterface[i]->isType(buf, fname)) {
	  fclose(file);
	  return kpinterface[i];
	}
      }
    }
    // check unenabled package handlers
    for (i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i]) {
	if (!opts->handlePackage[i] && kpinterface[i]->isType(buf, fname)) {
	  fclose(file);
	  return kpinterface[i];
	}
      }
    }
    fclose(file);
    KpMsgE(i18n("Unknown package type: %1").arg(fname),TRUE);
  } else {
    KpMsgE(i18n("File not found: %1").arg(fname),TRUE);
  }

  return 0;
}

/////////////////////////////////////////////////////////////////////////
int KPACKAGE::typeIndex(pkgInterface *type) {
  int i;
  for (i = 0; i < kpinterfaceN; i++) {
    if (type ==  kpinterface[i]) {
      return i;
    }
  }
  return -1;
}

void KPACKAGE::openNetFiles (const TQStringList &urls, bool install )
{
  TQStringList files;
  int i;
  int index;
  TQPtrList<packageInfo> **lst = new TQPtrList<packageInfo>*[kpinterfaceN];
  packageInfo *pk = 0;

  kdDebug() << "openNetFiles\n";

  for (TQStringList::ConstIterator it = urls.begin(); it != urls.end(); ++it) {
    files.append(fetchNetFile(*it));
    kpkg->add_recent_file(*it);
  }

  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
      lst[i] = new TQPtrList<packageInfo>;
    }
  }
  
  for (TQStringList::Iterator t = files.begin(); t != files.end(); ++t) {
    pkgInterface *type = pkType(*t);
    index = typeIndex(type);
    if (index >= 0) {
      pk = type->getPackageInfo('u', *t, 0);
      if (pk) {
	pk->pkgFileIns(*t);
	lst[index]->insert(0,pk);
        }
      }
    }

  if (install)
    for (i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i]) {
	if ( lst[i]->count() > 0) {
	  kpinterface[i]->installation->setup(lst[i],kpinterface[i]->head);
	  if (kpinterface[i]->installation->exec()) {
	    for (packageInfo *inf = lst[i]->first(); inf != 0; inf = lst[i]->next()) {
	      kpackage->management->updatePackage(inf,TRUE);
	    }
	  }
	}
      }
    } else {
      if (pk) {
	KpTreeListItem *pt = pk->item;
	// NOT the best place for this CODE
	kpackage->management->tabChanged(Opts::ALL);
	if (pt)
	  kpackage->management->packageHighlighted(pt);
      }
    }

  // Dealloc memory
  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
	delete lst[i];
    }
  }
  delete [] lst;
}

void KPACKAGE::openNetFile(const KURL &url, bool install )
{
  openNetFiles(url.url(), install);
}

//    KMimeMagic *magic = KMimeMagic::self();
//    KMimeMagicResult *r = magic->findFileType(s);
    //    printf("r=%s\n",(r->mimeType()).data());



TQString KPACKAGE::getFileName(const KURL & url, TQString &cacheName )
{
  TQString none  = "";
  TQString fname = "";

  if ( !url.isValid() )  {
    KpMsgE(i18n("Malformed URL: %1").arg(url.url()),TRUE);
  } else {

    // Just a usual file ?
    if ( url.isLocalFile() ) {
      cacheName = url.path();
      fname = url.path();
    } else {

      TQString tmpd = cacheObj::PDir();
      if (!tmpd.isEmpty()) {

	TQString cacheFile = tmpd + url.fileName();

	cacheName = cacheFile;
	TQFileInfo f(cacheFile);
	if (f.exists() && (opts->DCache != Opts::NEVER)) {
	  fname =  cacheFile;
	}
      }
    }
  }
  return fname;
}

bool KPACKAGE::isFileLocal( const KURL & url )
{
  TQString cf;

  TQString f = getFileName(url, cf);

  if (cf.isEmpty()) {
    return false;
  } else {
    if (!f.isEmpty()) {
      return true;
    } else {
      return false;
    }
  }
}

TQString KPACKAGE::fetchNetFile( const KURL & url )
{

  TQString cf;

  TQString f = getFileName(url, cf);

  if (cf.isEmpty()) {
    return "";
  } else {

    if (!f.isEmpty()) {
      return f;
    } else {
      save_url = url;

      setStatus(i18n("Starting TDEIO"));

      Kio tdeio;

      if (tdeio.download(url, cf)) {
	setStatus(i18n("TDEIO finished"));
	TQFileInfo fi(cf);
	if (!(fi.exists() && fi.size() > 0)) {
          unlink(TQFile::encodeName(cf));
	  return "";
	} else {
          CacheList cl(fi.dirPath());
          cl.append(fi.fileName());
          cl.write();
	  return cf;
	}
      } else {
	setStatus(i18n("TDEIO failed"));
	return "";
      }
    }
  }
}

/////////////////////////////////////////////////////////////////////////
void KPACKAGE::fileOpenUrl(){

  bool ok;

  TQString url = KInputDialog::getText( TQString(),
      i18n( "Open location:" ), save_url.prettyURL(), &ok, this );

  if ( ok )
    {
      kpkg->add_recent_file( url );
      openNetFile( url );
    }
}

void KPACKAGE::find(){
  if (srchdialog)
    srchdialog->show();
  else
    srchdialog = new Search(this, "find package");
}

void KPACKAGE::findf(){
  if (findialog)
    findialog->show();
  else
    findialog = new FindF(this);
}

KFileDialog* KPACKAGE::getFileDialog(const TQString &captiontext)
{

  if(!file_dialog) {
    file_dialog = new KFileDialog(TQDir::currentDirPath(), "",
				  this,"file_dialog",TRUE);
  }

  TQString pat;
  for (int i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i] && opts->handlePackage[i]) {
      pat += kpinterface[i]->packagePattern;
      pat += " ";
    }
  }
  file_dialog->setFilter(pat);
  file_dialog->setCaption(captiontext);
  //  file_dialog->rereadDir();

  return file_dialog;
}

void KPACKAGE::dragEnterEvent(TQDragEnterEvent* e)
{
  e->accept(KURLDrag::canDecode(e));
}

void KPACKAGE::dropEvent(TQDropEvent *de) // something has been dropped
{
  KURL::List list;
  if (!KURLDrag::decode(de, list) || list.isEmpty())
     return;

  openNetFiles(list.toStringList());
}

void KPACKAGE::setStatus(const TQString &s)	// set the text in the status bar
{
  status->setText(s);
  tdeApp->processEvents();	// refresh the screen
}

TQString KPACKAGE::getStatus()	// get the text in the status bar
{
  if(status)
    return status->text();
  else
    return "";
}

void KPACKAGE::setPercent(int x)	// set the progress in the status bar
{
  processProgress->setValue(x);
  tdeApp->processEvents();	// refresh it
}

//////////////////////////////////////////////////////////////////////////////



#include "kpackage.moc"
