/***************************************************************************
 *   Copyright (C) 2004 by Mario Bensi                                     *
 *   nef@ipsquad.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef _ALTITEMELEMENT_H_
#define _ALTITEMELEMENT_H_

#include <tqlistview.h>
#include <tdelistview.h>
#include <tqstring.h>
#include <tdeprocess.h>

class Alternative;
class AltController;

class AltItemElement :  public TQObject, public TQCheckListItem
{
	TQ_OBJECT
	
	Alternative *m_alt;
	TDEListView *m_parent;
	bool m_bisBroken;
	TQString m_path;
	TQString m_desc;
	
public:
    AltItemElement(TDEListView *parent, Alternative *alternative );
    ~AltItemElement();

    bool isBroken() const { return m_bisBroken; }
    TDEListView *getParent() const { return m_parent; }
    Alternative *getAlternative() { return m_alt; }
	TQString getPath() const {return m_path; }
	TQString getDescription() const {return m_desc;}
	void searchDescription();
	
private slots:
	void slotDescriptionTermined(TDEProcess *);
	void slotGetDescription(TDEProcess *proc, char *buffer, int buflen);
};

#endif //_ALTITEMELEMENT_H_
