/***************************************************************************
 *   Copyright Brian Ledbetter 2001-2003 <brian@shadowcom.net>             *
 *   Copyright Ravikiran Rajagopal 2003                                    *
 *   ravi@ee.eng.ohio-state.edu                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License (version 2) as   *
 *   published by the Free Software Foundation. (The original KSplash/ML   *
 *   codebase (upto version 0.95.3) is BSD-licensed.)                      *
 *                                                                         *
 ***************************************************************************/

// This file exists for the convenience of other KDE headers. It may change between
// different versions of KDE, and may disappear altogether. Do NOT include this
// directly in your program. We mean it.


#ifndef __WNDICON_H__
#define __WNDICON_H__

#include <kpixmap.h>

#include <tqhbox.h>

/**
 * @short Displays an icon on the screen.
 */
class WndIcon:
      public TQHBox
{
  TQ_OBJECT
public:

  enum Position
  {
    HBottomLeft = 0,
    HBottomRight = 1,
    HTopLeft = 2,
    HTopRight = 3,
    VBottomLeft = 10,
    VBottomRight = 11,
    VTopLeft = 12,
    VTopRight = 13
  };

  WndIcon( unsigned int, unsigned int, unsigned int, int, const KPixmap&, const TQString&, Position, bool, bool );

signals:
  void setStatusText( const TQString& );

public slots:
  void show();
  void noshow();
  void slotStopJumping();
  void slotJump();

private:
  TQPoint determinePosition();

protected:
  TQString mStatusText;
  Position mIconPos;
  int mXineramaScreen;
  int mPosX, mPosY, mGroundX, mGroundY;
  float mVelocity, mInitialVelocity, mGravity;
  int mIconNum, mStatusHeight, mIconSize;
  bool mStatusAtTop, mStopJump, mIconJumping;
};

#endif
