#!/usr/bin/env kjscmd

function newArticles( articles )
{

	var box = new TQVBox(main);
	var count = articles.call("count()");
	var label = new TQLabel(box);
	var list = new TDEListBox(box);


	label.text = count + " articles for " + articles.call("title()");
	for( var idx = 0; idx < count; ++idx)
	{
		var article = articles.call("article(int)", idx);
		list.insertItem( article.call( "title()" ));
	}
	box.show();
	return true;
}

var main = new TQHBox(this)
var dcop = new DCOPInterface(this, "news");
dcop.publish("void newArticles(DCOPRef)");

var client = new DCOPClient(this);
var feeds = client.call( "rssservice", "RSSService", "list()" );

for( var idx = 0; idx < feeds.length; ++idx)
{
	var doc = client.call( "rssservice", "RSSService", "add(TQString)", feeds[idx] );
	client.connectDCOPSignal("rssservice", doc.obj(), "documentUpdated(DCOPRef)",
			"news","newArticles(DCOPRef)");
	doc.call("refresh()");
}
main.show();

application.exec();

