
/** An object that supports signals and slots. */
class TQObject {};
/** Base-class of all widgets. */
class TQWidget : public TQObject {};
/** A widget that has a frame. */
class TQFrame : public TQWidget {};

/** Namespace for the KParts framework. */
namespace KParts {
    /** A base-class for plugins that extend a KPart. */
    class Plugin : public TQObject, public XMLGUIClient {};
    /** A base-class for KParts. */
    class Part : public TQObject, public XMLGUIClient {};
    /** A base-class for KParts that provide a read-only view. */
    class ReadOnlyPart : public Part {};
};

/** Namespace for the KJS interpreter library. */
namespace KJS {
    /** Provides the implementation for a KJS object. */
    class ObjectImp {};
};


