import org.trinitydesktop.qt.*;

public class Tut10 extends TQWidget {
	public Tut10() {
		TQPushButton quit = new TQPushButton("&Quit", this, "quit");
		quit.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(quit, TQ_SIGNAL("clicked()"), tqApp(), TQ_SLOT("quit()"));

		LCDRange angle = new LCDRange(this, "angle");
		angle.setRange(5, 70);

		LCDRange force = new LCDRange(this, "force");
		force.setRange(10, 50);

		CannonField cannonField = new CannonField(this, "cannonField");

		connect(angle, TQ_SIGNAL("valueChanged(int)"),
						cannonField, TQ_SLOT("setAngle(int)"));
		connect(cannonField, TQ_SIGNAL("angleChanged(int)"),
						angle, TQ_SLOT("setValue(int)"));

		connect(force, TQ_SIGNAL("valueChanged(int)"),
						cannonField, TQ_SLOT("setForce(int)"));
		connect(cannonField, TQ_SIGNAL("forceChanged(int)"),
						force, TQ_SLOT("setValue(int)"));

		TQGridLayout grid = new TQGridLayout(this, 2, 2, 10, -1, null);
		grid.addWidget(quit, 0, 0);
		grid.addWidget(cannonField, 1, 1);
		grid.setColStretch(1, 10);

		TQVBoxLayout leftBox = new TQVBoxLayout();
		grid.addLayout(leftBox, 1, 0);
		leftBox.addWidget(angle);
		leftBox.addWidget(force);

		angle.setValue(60);
		force.setValue(25);
		angle.setFocus();
	}
	
	public static void main(String[] args) {
		TQApplication.setColorSpec(TQApplication.CustomColor);
		TQApplication a = new TQApplication(args);
		Tut10 w = new Tut10();
		w.setGeometry( 100, 100, 500, 355 );
		
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.trinitydesktop.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
