//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQRect;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPixmap;
import org.trinitydesktop.qt.TQImage;
import org.trinitydesktop.qt.TQPoint;

/**

 KPixmapIO implements a fast path for TQPixmap to/from TQImage conversions.
 It uses the MIT-SHM shared memory extension for this. If this extension is
 not available, it will fall back to standard Qt methods.
 <li><b>Typical usage:</b></li>
 You can use KPixmapIO for load/saving pixmaps.
 <pre>
 KPixmapIO io;
 pixmap = io.convertToPixmap(image);
 image = io.convertToImage(pixmap);
 </pre>
 It also has functionality for partially updating/saving pixmaps, see
 putImage and getImage.
 <b>KPixmapIO vs. Qt speed comparison</b>\n
 Speed measurements were taken. These show that usage of KPixmapIO for
 images up to a certain threshold size, offers no speed advantage over
 the Qt routines. Below you can see a plot of these measurements.
 The threshold size, amongst other causes, is determined by the shared
 memory allocation policy. If the policy is <code>ShmDontKeep</code>, the
 shared memory segment is discarded right after usage, and thus needs to
 be allocated before each transfer. This introduces a a setup penalty not
 present when the policy is <code>ShmKeepAndGrow.</code> In this case the
 shared memory segment is kept and resized when necessary, until the
 KPixmapIO object is destroyed.
 The default policy is <code>ShmDontKeep.</code> This policy makes sense when
 loading pixmaps once. The corresponding threshold is taken at 5.000
 pixels as suggested by experiments. Below this threshold, KPixmapIO
 will not use shared memory and fall back on the Qt routines.
 When the policy is <code>ShmKeepAndGrow</code>, the threshold is taken at
 2.000 pixels. Using this policy, you might want to use preAllocShm
 to pre-allocate a certain amount of shared memory, in order to avoid
 resizes. This allocation policy makes sense in a multimedia type
 application where you are constantly updating the screen.
 Above a couple times the threshold size, KPixmapIO's and Qt's speed become
 linear in the number of pixels, KPixmapIO being at least 2, and mostly around
 4 times faster than Qt, depending on the screen and image depth.
 Speed difference seems to be the most at 16 bpp, followed by 32 and 24
 bpp respectively. This can be explained by the relatively poor
 implementation of 16 bit RGB packing in Qt, while at 32 bpp we need to
 transfer more data, and thus gain more, than at 24 bpp.
 <li><b>Conclusion:</b></li>
 For large pixmaps, there's a definite speed improvement when using
 KPixmapIO. On the other hand, there's no speed improvement for small
 pixmaps. When you know you're only transferring small pixmaps, there's no
 point in using it.
 		@author Geert Jansen <jansen@kde.org>

		@version $Id$

		@short Fast TQImage to/from TQPixmap conversion.

*/
public class KPixmapIO implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KPixmapIO(Class dummy){}

	/**
		 Shared memory allocation policies.
		     		@short    Shared memory allocation policies.
	*/
	public static final int ShmDontKeep = 0;
	public static final int ShmKeepAndGrow = 1;

	public KPixmapIO() {
		newKPixmapIO();
	}
	private native void newKPixmapIO();
	/**
		 Convert an image to a pixmap.
			@param image The image to convert.
				@return The pixmap containing the image.

		@short    Convert an image to a pixmap.
	*/
	public native TQPixmap convertToPixmap(TQImage image);
	/**
		 Convert a pixmap to an image.
			@param pixmap The pixmap to convert.
				@return The image.

		@short    Convert a pixmap to an image.
	*/
	public native TQImage convertToImage(TQPixmap pixmap);
	/**
		 Bitblt an image onto a pixmap.
			@param dst The destination pixmap.
			@param dx Destination x offset.
			@param dy Destination y offset.
			@param src The image to load.
		     		@short    Bitblt an image onto a pixmap.
	*/
	public native void putImage(TQPixmap dst, int dx, int dy, TQImage src);
	/**
		 This function is identical to the one above. It only differs in the
		 arguments it accepts.
		     		@short    This function is identical to the one above.
	*/
	public native void putImage(TQPixmap dst, TQPoint offset, TQImage src);
	/**
		 Transfer (a part of) a pixmap to an image.
			@param src The source pixmap.
			@param sx Source x offset.
			@param sy Source y offset.
			@param sw Source width.
			@param sh Source height.
				@return The image.

		@short    Transfer (a part of) a pixmap to an image.
	*/
	public native TQImage getImage(TQPixmap src, int sx, int sy, int sw, int sh);
	/**
		 This function is identical to the one above. It only differs in the
		 arguments it accepts.
		     		@short    This function is identical to the one above.
	*/
	public native TQImage getImage(TQPixmap src, TQRect rect);
	/**
		 Set the shared memory allocation policy. See the introduction for
		 KPixmapIO for a discussion.
			@param policy The alloction policy.
		     		@short    Set the shared memory allocation policy.
	*/
	public native void setShmPolicy(int policy);
	/**
		 Pre-allocate shared memory. KPixmapIO will be able to transfer images
		 up to this size without resizing.
			@param size The size of the image in <code>pixels.</code>
		     		@short    Pre-allocate shared memory.
	*/
	public native void preAllocShm(int size);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
