//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQFile;
import org.trinitydesktop.qt.TQDataStream;
import org.trinitydesktop.qt.TQTextStream;

/**

 The KTempFile class creates and opens a unique file for temporary use.
 This is especially useful if you need to create a file in a world
 writable directory like /tmp without being vulnerable to so called
 symlink attacks.
 KDE applications, however, shouldn't create files in /tmp in the first
 place but use the "tmp" resource instead. The standard KTempFile
 constructor will do that by default.
 To create a temporary file that starts with a certain name
 in the "tmp" resource, one should use:
 KTempFile(locateLocal("tmp", prefix), extension);
 KTempFile does not create any missing directories, but locateLocal() does.
 See also TDEStandardDirs
		@author Waldo Bastian <bastian@kde.org>

		@short    The KTempFile class creates and opens a unique file for temporary use.

*/
public class KTempFile implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KTempFile(Class dummy){}

	/**
		 Creates a temporary file with the name:
		  \<filePrefix>\<six letters>\<fileExtension>
			 The default <code>filePrefix</code> is "$TDEHOME/tmp-$HOST/appname/"
		 The default <code>fileExtension</code> is ".tmp"
			@param filePrefix the prefix of the file name, or null
		        for the default value
			@param fileExtension the extension of the prefix, or null for the
		        default value
			@param mode the file permissions
				@short    Creates a temporary file with the name:   \<filePrefix>\<six letters>\<fileExtension>
	*/
	public KTempFile(String filePrefix, String fileExtension, int mode) {
		newKTempFile(filePrefix,fileExtension,mode);
	}
	private native void newKTempFile(String filePrefix, String fileExtension, int mode);
	public KTempFile(String filePrefix, String fileExtension) {
		newKTempFile(filePrefix,fileExtension);
	}
	private native void newKTempFile(String filePrefix, String fileExtension);
	public KTempFile(String filePrefix) {
		newKTempFile(filePrefix);
	}
	private native void newKTempFile(String filePrefix);
	public KTempFile() {
		newKTempFile();
	}
	private native void newKTempFile();
	/**
		 Turn automatic deletion on or off.
		 Automatic deletion is off by default.
			@param autoDelete true to turn automatic deletion on
				@short    Turn automatic deletion on or off.
	*/
	public native void setAutoDelete(boolean autoDelete);
	/**
		 Returns the status of the file based on errno. (see errno.h)
		 0 means OK.
			 You should check the status after object creation to check
		 whether a file could be created in the first place.
			 You may check the status after closing the file to verify that
		 the file has indeed been written correctly.
				@return the errno status, 0 means ok

		@short    Returns the status of the file based on errno.
	*/
	public native int status();
	/**
		 Returns the full path and name of the file.
			 Note that in most circumstances the file needs to be closed
		 before you use it by name.
			 In particular, if another process or software part needs to write data
		 to the file based on the filename, the file should be closed before doing
		 so. Otherwise the act of closing the file later on may cause the file to
		 get truncated to a zero-size, resulting in an unexpected loss of the data.
			 In some cases there is only interest in the filename itself but where the
		 actual presence of a file with such name is a problem. In that case the
		 file should first be both closed and unlinked. Such usage is not recommended
		 since it may lead to the kind of symlink vulnerabilities that the KTempFile
		 design attempts to prevent.
				@return The name of the file, or null if opening the
         file has failed or the file has been unlinked already.

		@short    Returns the full path and name of the file.
	*/
	public native String name();
	/**
		 An integer file descriptor open for writing to the file
				@return The file descriptor, or a negative number if opening
         the file failed

		@short    An integer file descriptor open for writing to the file
	*/
	public native int handle();
	/**
		 Returns the FILE of the temporary file.
				@return FILE* stream open for writing to the file, or 0
         if opening the file failed

		@short    Returns the FILE  of the temporary file.
	*/
	// FILE* fstream(); >>>> NOT CONVERTED
	/**
		 Returns the TQTextStream for writing.
				@return TQTextStream open for writing to the file, or 0
         if opening the file failed

		@short    Returns the TQTextStream for writing.
	*/
	public native TQTextStream textStream();
	/**
		 Returns a TQDataStream for writing.
				@return TQDataStream open for writing to the file, or 0
         if opening the file failed

		@short    Returns a TQDataStream for writing.
	*/
	public native TQDataStream dataStream();
	/**
		 Returns a TQFile.
				@return A TQFile open for writing to the file, or 0 if
         opening the file failed.

		@short    Returns a TQFile.
	*/
	public native TQFile file();
	/**
		 Unlinks the file from the directory. The file is
		 deleted once the last reader/writer closes it.
				@short    Unlinks the file from the directory.
	*/
	public native void unlink();
	/**
		 Flushes file to disk (fsync).
			 If you want to be as sure as possible that the file data has
		 actually been physically stored on disk you need to call sync().
			 See status() for details about errors.
				@return true if successful, or false if an error has occurred.

		@short    Flushes file to disk (fsync).
	*/
	public native boolean sync();
	/**
		 Closes the file.
			 See status() for details about errors.
				@return true if successful, or false if an error has occurred.

		@short    Closes the file.
	*/
	public native boolean close();
	/**
		 Constructor used by KSaveFile
				@short    Constructor used by KSaveFile
	*/
	public KTempFile(boolean arg1) {
		newKTempFile(arg1);
	}
	private native void newKTempFile(boolean arg1);
	/**
			 Create function used internally by KTempFile and KSaveFile
				@short
	*/
	protected native boolean create(String filePrefix, String fileExtension, int mode);
	protected native void setError(int error);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
