//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPixmap;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQWidget;

/**

 This combobox shows a number of recent URLs/directories, as well as some
 default directories.
 It will manage the default dirs root-directory, home-directory and
 Desktop-directory, as well as a number of URLs set via setURLs()
 and one additional entry to be set via setURL().
 See {@link KURLComboBoxSignals} for signals emitted by KURLComboBox
		@author Carsten Pfeiffer <pfeiffer@kde.org>

		@short A combo box showing a number of recent URLs/directories.

*/
public class KURLComboBox extends KComboBox  {
	protected KURLComboBox(Class dummy){super((Class) null);}
	/**
		 This enum describes which kind of items is shown in the combo box.
		     		@short    This enum describes which kind of items is shown in the combo box.
	*/
	public static final int Files = -1;
	public static final int Directories = 1;
	public static final int Both = 0;

	/**
		 This Enumeration is used in setURL() to determine which items
		 will be removed when the given list is larger than maxItems().

			<li>
			RemoveTop means that items will be removed from top
			</li>

			<li>
			RemoveBottom means, that items will be removed from the bottom

			</li>		@short    This Enumeration is used in setURL() to determine which items  will be removed when the given list is larger than maxItems().
	*/
	public static final int RemoveTop = 0;
	public static final int RemoveBottom = 1;

	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructs a KURLComboBox.
			@param mode is either Files, Directories or Both and controls the
		 following behavior:

			<li>
			Files  all inserted URLs will be treated as files, therefore the
			            url shown in the combo will never show a trailing /
			            the icon will be the one associated with the file's mimetype.
			</li>

			<li>
			Directories  all inserted URLs will be treated as directories, will
			                  have a trailing slash in the combobox. The current
			                  directory will show the "open folder" icon, other
			                  directories the "folder" icon.
			</li>

			<li>
			Both  Don't mess with anything, just show the url as given.
			</li>
				@param parent The parent object of this widget.
			@param name The name of this widget.
		     		@short    Constructs a KURLComboBox.
	*/
	public KURLComboBox(int mode, TQWidget parent, String name) {
		super((Class) null);
		newKURLComboBox(mode,parent,name);
	}
	private native void newKURLComboBox(int mode, TQWidget parent, String name);
	public KURLComboBox(int mode, TQWidget parent) {
		super((Class) null);
		newKURLComboBox(mode,parent);
	}
	private native void newKURLComboBox(int mode, TQWidget parent);
	public KURLComboBox(int mode) {
		super((Class) null);
		newKURLComboBox(mode);
	}
	private native void newKURLComboBox(int mode);
	public KURLComboBox(int mode, boolean rw, TQWidget parent, String name) {
		super((Class) null);
		newKURLComboBox(mode,rw,parent,name);
	}
	private native void newKURLComboBox(int mode, boolean rw, TQWidget parent, String name);
	public KURLComboBox(int mode, boolean rw, TQWidget parent) {
		super((Class) null);
		newKURLComboBox(mode,rw,parent);
	}
	private native void newKURLComboBox(int mode, boolean rw, TQWidget parent);
	public KURLComboBox(int mode, boolean rw) {
		super((Class) null);
		newKURLComboBox(mode,rw);
	}
	private native void newKURLComboBox(int mode, boolean rw);
	/**
		 Sets the current url. This combo handles exactly one url additionally
		 to the default items and those set via setURLs(). So you can call
		 setURL() as often as you want, it will always replace the previous one
		 set via setURL().
		 If <code>url</code> is already in the combo, the last item will stay there
		 and the existing item becomes the current item.
		 The current item will always have the open-directory-pixmap as icon.
			 Note that you won't receive any signals, e.g. textChanged(),
		 returnPressed() or activated() upon calling this method.
		     		@short    Sets the current url.
	*/
	public native void setURL(KURL url);
	/**
		 Inserts <code>urls</code> into the combobox below the "default urls" (see
		 addDefaultURL).
			 If the list of urls contains more items than maxItems, the first items
		 will be stripped.
		     		@short    Inserts <code>urls</code> into the combobox below the "default urls" (see  addDefaultURL).
	*/
	public native void setURLs(String[] urls);
	/**
		 Inserts <code>urls</code> into the combobox below the "default urls" (see
		 addDefaultURL).
			 If the list of urls contains more items than maxItems, the <code>remove</code>
		 parameter determines whether the first or last items will be stripped.
		     		@short    Inserts <code>urls</code> into the combobox below the "default urls" (see  addDefaultURL).
	*/
	public native void setURLs(String[] urls, int remove);
	/**
				@return a list of all urls currently handled. The list contains at most
 maxItems() items.
 Use this to save the list of urls in a config-file and reinsert them
 via setURLs() next time.
 Note that all default urls set via addDefaultURL() are not
 returned, they will automatically be set via setURLs() or setURL().
 You will always get fully qualified urls, i.e. with protocol like
 file:/

		@short
	*/
	public native ArrayList urls();
	/**
		 Sets how many items should be handled and displayed by the combobox.
				@short    Sets how many items should be handled and displayed by the combobox.
		@see #maxItems
	*/
	public native void setMaxItems(int arg1);
	/**
				@return the maximum of items the combobox handles.

		@short
		@see #setMaxItems
	*/
	public native int maxItems();
	/**
		 Adds a url that will always be shown in the combobox, it can't be
		 "rotated away". Default urls won't be returned in urls() and don't
		 have to be set via setURLs().
		 If you want to specify a special pixmap, use the overloaded method with
		 the pixmap parameter.
		 Default URLs will be inserted into the combobox by setDefaults()
		     		@short    Adds a url that will always be shown in the combobox, it can't be  "rotated away".
	*/
	public native void addDefaultURL(KURL url, String text);
	public native void addDefaultURL(KURL url);
	/**
		 Adds a url that will always be shown in the combobox, it can't be
		 "rotated away". Default urls won't be returned in urls() and don't
		 have to be set via setURLs().
		 If you don't need to specify a pixmap, use the overloaded method without
		 the pixmap parameter.
		 Default URLs will be inserted into the combobox by setDefaults()
		     		@short    Adds a url that will always be shown in the combobox, it can't be  "rotated away".
	*/
	public native void addDefaultURL(KURL url, TQPixmap pix, String text);
	public native void addDefaultURL(KURL url, TQPixmap pix);
	/**
		 Clears all items and inserts the default urls into the combo. Will be
		 called implicitly upon the first call to setURLs() or setURL()
				@short    Clears all items and inserts the default urls into the combo.
		@see #addDefaultURL
	*/
	public native void setDefaults();
	/**
		 Removes any occurrence of <code>url.</code> If <code>checkDefaultURLs</code> is false
		 default-urls won't be removed.
		     		@short    Removes any occurrence of <code>url.</code>
	*/
	public native void removeURL(KURL url, boolean checkDefaultURLs);
	public native void removeURL(KURL url);
	protected native void init(int mode);
	// void insertURLItem(const KURLComboBox::KURLComboItem* arg1); >>>> NOT CONVERTED
	/**
		 Uses KMimeType.pixmapForURL() to return a proper pixmap for <code>url.</code>
		 In directory mode, a folder icon is always returned.
		     		@short    Uses KMimeType.pixmapForURL() to return a proper pixmap for <code>url.</code>
	*/
	protected native TQPixmap getPixmap(KURL url);
	/**
		 Updates <code>item</code> with <code>pixmap</code> and sets the url instead of the text
		 of the KURLComboItem.
		 Also works around a Qt bug.
		     		@short    Updates <code>item</code> with <code>pixmap</code> and sets the url instead of the text  of the KURLComboItem.
	*/
	// void updateItem(const KURLComboBox::KURLComboItem* arg1,int arg2,const TQPixmap& arg3); >>>> NOT CONVERTED
	protected native void slotActivated(int arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
