/***************************************************************************
                          tdesupport.h  -  description
                             -------------------
    begin                : Mon Feb 5 2001
    copyright            : (C) 2001 by Richard Dale
    email                : Lost_Highway@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TDESUPPORT_H
#define TDESUPPORT_H

#include <jni.h>

#include <tqptrlist.h>
#include <ktrader.h>
#include <tdemainwindow.h>
#include <tdefile.h>
#include <tdefileview.h>
#include <kurl.h>
#include <tdecmdlineargs.h>
#include <dom/dom_string.h>
#include <dom/dom_node.h>
#include <dom/css_stylesheet.h>

/** A class with various static utility methods to help run the C++ side
	of the KDE Java library.

	@author Richard Dale */

class KDESupport {
public:
	KDESupport() {};
	~KDESupport() {};

	/** Convert from Java String to DOM::DOMString */
	static DOM::DOMString * toDOMString(JNIEnv * env, jstring str, DOM::DOMString ** domstring);
	static jstring fromDOMString(JNIEnv * env, DOM::DOMString * domstring);

	/** Convert from a Java ArrayList to a KURL::List */
	static KURL::List * toKURLList(JNIEnv * env, jobjectArray urlList, KURL::List ** kurlList);
	/** Convert from a Java ArrayList to a KFileItemList */
	static KFileItemList * toKFileItemList(JNIEnv * env, jobjectArray itemList, KFileItemList ** kitemList);

	/** Converts java options entries to the C++ TDECmdLineOption equivalent */
	static TDECmdLineOptions * toTDECmdLineOptions(JNIEnv * env, jobjectArray optionsArray);

	/** Converts a java.io.ByteArrayOutputStream to a TQByteArray */
	static TQByteArray * toTQByteArrayFromStream(JNIEnv * env, TQByteArray * byteArray, jobject byteStream);

	/** Returns a Java ArrayList for the various types of KDE List */
	static jobject arrayWithQCStringList(JNIEnv * env, QCStringList * qcstringList);
	static jobject arrayWithOfferList(JNIEnv * env, TDETrader::OfferList * offerList);
	static jobject arrayWithTDEMainWindowList(JNIEnv * env, TQPtrList<TDEMainWindow>* memberList);
	static jobject arrayWithKFileItemList(JNIEnv * env, KFileItemList * itemList);
	static jobject arrayWithKURLList(JNIEnv * env, KURL::List * kurlList);
	static jobject arrayWithNodeList(JNIEnv * env, DOM::NodeList * nodeList);
	static jobject arrayWithStyleSheetList(JNIEnv * env, DOM::StyleSheetList * styleSheetList);
	static jobject arrayWithMediaList(JNIEnv * env, DOM::MediaList * mediaList);

	/** Convert from ArrayList to QCStringList */
	static QCStringList * toQCStringList(JNIEnv * env, jobjectArray stringList, QCStringList ** qstringList);

};

#endif
