


#include <tqcstring.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqnamespace.h>
#include "qt_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QtImp::QtImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QtImp::~QtImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QtImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QtImp *meth = new QtImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


    //
    // Define the enum constants
    //
    struct EnumValue {
	const char *id;
	int val;
    };

    EnumValue enums[] = {

        // enum ButtonState
        { "NoButton", TQt::NoButton },
        { "LeftButton", TQt::LeftButton },
        { "RightButton", TQt::RightButton },
        { "MidButton", TQt::MidButton },
        { "MouseButtonMask", TQt::MouseButtonMask },
        { "ShiftButton", TQt::ShiftButton },
        { "ControlButton", TQt::ControlButton },
        { "AltButton", TQt::AltButton },
        { "MetaButton", TQt::MetaButton },
        { "KeyButtonMask", TQt::KeyButtonMask },
        { "Keypad", TQt::Keypad },
        // enum Orientation
        { "Horizontal", TQt::Horizontal },
        { "Vertical", TQt::Vertical },
        // enum SortOrder
        { "Ascending", TQt::Ascending },
        { "Descending", TQt::Descending },
        // enum AlignmentFlags
        { "AlignAuto", TQt::AlignAuto },
        { "AlignLeft", TQt::AlignLeft },
        { "AlignRight", TQt::AlignRight },
        { "AlignHCenter", TQt::AlignHCenter },
        { "AlignJustify", TQt::AlignJustify },
        { "AlignHorizontal_Mask", TQt::AlignHorizontal_Mask },
        { "AlignTop", TQt::AlignTop },
        { "AlignBottom", TQt::AlignBottom },
        { "AlignVCenter", TQt::AlignVCenter },
        { "AlignVertical_Mask", TQt::AlignVertical_Mask },
        { "AlignCenter", TQt::AlignCenter },
        // enum TextFlags
        { "SingleLine", TQt::SingleLine },
        { "DontClip", TQt::DontClip },
        { "ExpandTabs", TQt::ExpandTabs },
        { "ShowPrefix", TQt::ShowPrefix },
        { "WordBreak", TQt::WordBreak },
        { "BreakAnywhere", TQt::BreakAnywhere },
        { "DontPrint", TQt::DontPrint },
        { "Underline", TQt::Underline },
        { "Overline", TQt::Overline },
        { "StrikeOut", TQt::StrikeOut },
        { "IncludeTrailingSpaces", TQt::IncludeTrailingSpaces },
        { "NoAccel", TQt::NoAccel },
        // enum WidgetState
        { "WState_Created", TQt::WState_Created },
        { "WState_Disabled", TQt::WState_Disabled },
        { "WState_Visible", TQt::WState_Visible },
        { "WState_ForceHide", TQt::WState_ForceHide },
        { "WState_OwnCursor", TQt::WState_OwnCursor },
        { "WState_MouseTracking", TQt::WState_MouseTracking },
        { "WState_CompressKeys", TQt::WState_CompressKeys },
        { "WState_BlockUpdates", TQt::WState_BlockUpdates },
        { "WState_InPaintEvent", TQt::WState_InPaintEvent },
        { "WState_Reparented", TQt::WState_Reparented },
        { "WState_ConfigPending", TQt::WState_ConfigPending },
        { "WState_Resized", TQt::WState_Resized },
        { "WState_AutoMask", TQt::WState_AutoMask },
        { "WState_Polished", TQt::WState_Polished },
        { "WState_DND", TQt::WState_DND },
        { "WState_Reserved0", TQt::WState_Reserved0 },
        { "WState_FullScreen", TQt::WState_FullScreen },
        { "WState_OwnSizePolicy", TQt::WState_OwnSizePolicy },
        { "WState_CreatedHidden", TQt::WState_CreatedHidden },
        { "WState_Maximized", TQt::WState_Maximized },
        { "WState_Minimized", TQt::WState_Minimized },
        { "WState_ForceDisabled", TQt::WState_ForceDisabled },
        { "WState_Exposed", TQt::WState_Exposed },
        { "WState_HasMouse", TQt::WState_HasMouse },
        // enum WidgetFlags
        { "WType_TopLevel", TQt::WType_TopLevel },
        { "WType_Dialog", TQt::WType_Dialog },
        { "WType_Popup", TQt::WType_Popup },
        { "WType_Desktop", TQt::WType_Desktop },
        { "WType_Mask", TQt::WType_Mask },
        { "WStyle_Customize", TQt::WStyle_Customize },
        { "WStyle_NormalBorder", TQt::WStyle_NormalBorder },
        { "WStyle_DialogBorder", TQt::WStyle_DialogBorder },
        { "WStyle_NoBorder", TQt::WStyle_NoBorder },
        { "WStyle_Title", TQt::WStyle_Title },
        { "WStyle_SysMenu", TQt::WStyle_SysMenu },
        { "WStyle_Minimize", TQt::WStyle_Minimize },
        { "WStyle_Maximize", TQt::WStyle_Maximize },
        { "WStyle_MinMax", TQt::WStyle_MinMax },
        { "WStyle_Tool", TQt::WStyle_Tool },
        { "WStyle_StaysOnTop", TQt::WStyle_StaysOnTop },
        { "WStyle_ContextHelp", TQt::WStyle_ContextHelp },
        { "WStyle_Reserved", TQt::WStyle_Reserved },
        { "WStyle_Mask", TQt::WStyle_Mask },
        { "WDestructiveClose", TQt::WDestructiveClose },
        { "WPaintDesktop", TQt::WPaintDesktop },
        { "WPaintUnclipped", TQt::WPaintUnclipped },
        { "WPaintClever", TQt::WPaintClever },
        { "WResizeNoErase", TQt::WResizeNoErase },
        { "WMouseNoMask", TQt::WMouseNoMask },
        { "WStaticContents", TQt::WStaticContents },
        { "WRepaintNoErase", TQt::WRepaintNoErase },
        { "WX11BypassWM", TQt::WX11BypassWM },
        { "WWinOwnDC", TQt::WWinOwnDC },
        { "WMacNoSheet", TQt::WMacNoSheet },
        { "WMacDrawer", TQt::WMacDrawer },
        { "WGroupLeader", TQt::WGroupLeader },
        { "WShowModal", TQt::WShowModal },
        { "WNoMousePropagation", TQt::WNoMousePropagation },
        { "WSubWindow", TQt::WSubWindow },
        { "WStyle_Splash", TQt::WStyle_Splash },
        { "WNoAutoErase", TQt::WNoAutoErase },
        { "WNorthWestGravity", TQt::WNorthWestGravity },
        { "WType_Modal", TQt::WType_Modal },
        { "WStyle_Dialog", TQt::WStyle_Dialog },
        { "WStyle_NoBorderEx", TQt::WStyle_NoBorderEx },
        // enum WindowState
        { "WindowNoState", TQt::WindowNoState },
        { "WindowMinimized", TQt::WindowMinimized },
        { "WindowMaximized", TQt::WindowMaximized },
        { "WindowFullScreen", TQt::WindowFullScreen },
        { "WindowActive", TQt::WindowActive },
        // enum ImageConversionFlags
        { "ColorMode_Mask", TQt::ColorMode_Mask },
        { "AutoColor", TQt::AutoColor },
        { "ColorOnly", TQt::ColorOnly },
        { "MonoOnly", TQt::MonoOnly },
        { "AlphaDither_Mask", TQt::AlphaDither_Mask },
        { "ThresholdAlphaDither", TQt::ThresholdAlphaDither },
        { "OrderedAlphaDither", TQt::OrderedAlphaDither },
        { "DiffuseAlphaDither", TQt::DiffuseAlphaDither },
        { "NoAlpha", TQt::NoAlpha },
        { "Dither_Mask", TQt::Dither_Mask },
        { "DiffuseDither", TQt::DiffuseDither },
        { "OrderedDither", TQt::OrderedDither },
        { "ThresholdDither", TQt::ThresholdDither },
        { "DitherMode_Mask", TQt::DitherMode_Mask },
        { "AutoDither", TQt::AutoDither },
        { "PreferDither", TQt::PreferDither },
        { "AvoidDither", TQt::AvoidDither },
        // enum BGMode
        { "TransparentMode", TQt::TransparentMode },
        { "OpaqueMode", TQt::OpaqueMode },
        // enum PaintUnit
        { "PixelUnit", TQt::PixelUnit },
        { "LoMetricUnit", TQt::LoMetricUnit },
        { "HiMetricUnit", TQt::HiMetricUnit },
        { "LoEnglishUnit", TQt::LoEnglishUnit },
        { "HiEnglishUnit", TQt::HiEnglishUnit },
        { "TwipsUnit", TQt::TwipsUnit },
        // enum GUIStyle
        { "MacStyle", TQt::MacStyle },
        { "WindowsStyle", TQt::WindowsStyle },
        { "Win3Style", TQt::Win3Style },
        { "PMStyle", TQt::PMStyle },
        { "MotifStyle", TQt::MotifStyle },
        // enum SequenceMatch
        { "NoMatch", TQt::NoMatch },
        { "PartialMatch", TQt::PartialMatch },
        { "Identical", TQt::Identical },
        // enum Modifier
        { "META", TQt::META },
        { "SHIFT", TQt::SHIFT },
        { "CTRL", TQt::CTRL },
        { "ALT", TQt::ALT },
        { "MODIFIER_MASK", TQt::MODIFIER_MASK },
        { "UNICODE_ACCEL", TQt::UNICODE_ACCEL },
        { "ASCII_ACCEL", TQt::ASCII_ACCEL },
        // enum Key
        { "Key_Escape", TQt::Key_Escape },
        { "Key_Tab", TQt::Key_Tab },
        { "Key_Backtab", TQt::Key_Backtab },
        { "Key_BackTab", TQt::Key_BackTab },
        { "Key_Backspace", TQt::Key_Backspace },
        { "Key_BackSpace", TQt::Key_BackSpace },
        { "Key_Return", TQt::Key_Return },
        { "Key_Enter", TQt::Key_Enter },
        { "Key_Insert", TQt::Key_Insert },
        { "Key_Delete", TQt::Key_Delete },
        { "Key_Pause", TQt::Key_Pause },
        { "Key_Print", TQt::Key_Print },
        { "Key_SysReq", TQt::Key_SysReq },
        { "Key_Clear", TQt::Key_Clear },
        { "Key_Home", TQt::Key_Home },
        { "Key_End", TQt::Key_End },
        { "Key_Left", TQt::Key_Left },
        { "Key_Up", TQt::Key_Up },
        { "Key_Right", TQt::Key_Right },
        { "Key_Down", TQt::Key_Down },
        { "Key_Prior", TQt::Key_Prior },
        { "Key_PageUp", TQt::Key_PageUp },
        { "Key_Next", TQt::Key_Next },
        { "Key_PageDown", TQt::Key_PageDown },
        { "Key_Shift", TQt::Key_Shift },
        { "Key_Control", TQt::Key_Control },
        { "Key_Meta", TQt::Key_Meta },
        { "Key_Alt", TQt::Key_Alt },
        { "Key_CapsLock", TQt::Key_CapsLock },
        { "Key_NumLock", TQt::Key_NumLock },
        { "Key_ScrollLock", TQt::Key_ScrollLock },
        { "Key_F1", TQt::Key_F1 },
        { "Key_F2", TQt::Key_F2 },
        { "Key_F3", TQt::Key_F3 },
        { "Key_F4", TQt::Key_F4 },
        { "Key_F5", TQt::Key_F5 },
        { "Key_F6", TQt::Key_F6 },
        { "Key_F7", TQt::Key_F7 },
        { "Key_F8", TQt::Key_F8 },
        { "Key_F9", TQt::Key_F9 },
        { "Key_F10", TQt::Key_F10 },
        { "Key_F11", TQt::Key_F11 },
        { "Key_F12", TQt::Key_F12 },
        { "Key_F13", TQt::Key_F13 },
        { "Key_F14", TQt::Key_F14 },
        { "Key_F15", TQt::Key_F15 },
        { "Key_F16", TQt::Key_F16 },
        { "Key_F17", TQt::Key_F17 },
        { "Key_F18", TQt::Key_F18 },
        { "Key_F19", TQt::Key_F19 },
        { "Key_F20", TQt::Key_F20 },
        { "Key_F21", TQt::Key_F21 },
        { "Key_F22", TQt::Key_F22 },
        { "Key_F23", TQt::Key_F23 },
        { "Key_F24", TQt::Key_F24 },
        { "Key_F25", TQt::Key_F25 },
        { "Key_F26", TQt::Key_F26 },
        { "Key_F27", TQt::Key_F27 },
        { "Key_F28", TQt::Key_F28 },
        { "Key_F29", TQt::Key_F29 },
        { "Key_F30", TQt::Key_F30 },
        { "Key_F31", TQt::Key_F31 },
        { "Key_F32", TQt::Key_F32 },
        { "Key_F33", TQt::Key_F33 },
        { "Key_F34", TQt::Key_F34 },
        { "Key_F35", TQt::Key_F35 },
        { "Key_Super_L", TQt::Key_Super_L },
        { "Key_Super_R", TQt::Key_Super_R },
        { "Key_Menu", TQt::Key_Menu },
        { "Key_Hyper_L", TQt::Key_Hyper_L },
        { "Key_Hyper_R", TQt::Key_Hyper_R },
        { "Key_Help", TQt::Key_Help },
        { "Key_Direction_L", TQt::Key_Direction_L },
        { "Key_Direction_R", TQt::Key_Direction_R },
        { "Key_Space", TQt::Key_Space },
        { "Key_Any", TQt::Key_Any },
        { "Key_Exclam", TQt::Key_Exclam },
        { "Key_QuoteDbl", TQt::Key_QuoteDbl },
        { "Key_NumberSign", TQt::Key_NumberSign },
        { "Key_Dollar", TQt::Key_Dollar },
        { "Key_Percent", TQt::Key_Percent },
        { "Key_Ampersand", TQt::Key_Ampersand },
        { "Key_Apostrophe", TQt::Key_Apostrophe },
        { "Key_ParenLeft", TQt::Key_ParenLeft },
        { "Key_ParenRight", TQt::Key_ParenRight },
        { "Key_Asterisk", TQt::Key_Asterisk },
        { "Key_Plus", TQt::Key_Plus },
        { "Key_Comma", TQt::Key_Comma },
        { "Key_Minus", TQt::Key_Minus },
        { "Key_Period", TQt::Key_Period },
        { "Key_Slash", TQt::Key_Slash },
        { "Key_0", TQt::Key_0 },
        { "Key_1", TQt::Key_1 },
        { "Key_2", TQt::Key_2 },
        { "Key_3", TQt::Key_3 },
        { "Key_4", TQt::Key_4 },
        { "Key_5", TQt::Key_5 },
        { "Key_6", TQt::Key_6 },
        { "Key_7", TQt::Key_7 },
        { "Key_8", TQt::Key_8 },
        { "Key_9", TQt::Key_9 },
        { "Key_Colon", TQt::Key_Colon },
        { "Key_Semicolon", TQt::Key_Semicolon },
        { "Key_Less", TQt::Key_Less },
        { "Key_Equal", TQt::Key_Equal },
        { "Key_Greater", TQt::Key_Greater },
        { "Key_Question", TQt::Key_Question },
        { "Key_At", TQt::Key_At },
        { "Key_A", TQt::Key_A },
        { "Key_B", TQt::Key_B },
        { "Key_C", TQt::Key_C },
        { "Key_D", TQt::Key_D },
        { "Key_E", TQt::Key_E },
        { "Key_F", TQt::Key_F },
        { "Key_G", TQt::Key_G },
        { "Key_H", TQt::Key_H },
        { "Key_I", TQt::Key_I },
        { "Key_J", TQt::Key_J },
        { "Key_K", TQt::Key_K },
        { "Key_L", TQt::Key_L },
        { "Key_M", TQt::Key_M },
        { "Key_N", TQt::Key_N },
        { "Key_O", TQt::Key_O },
        { "Key_P", TQt::Key_P },
        { "Key_Q", TQt::Key_Q },
        { "Key_R", TQt::Key_R },
        { "Key_S", TQt::Key_S },
        { "Key_T", TQt::Key_T },
        { "Key_U", TQt::Key_U },
        { "Key_V", TQt::Key_V },
        { "Key_W", TQt::Key_W },
        { "Key_X", TQt::Key_X },
        { "Key_Y", TQt::Key_Y },
        { "Key_Z", TQt::Key_Z },
        { "Key_BracketLeft", TQt::Key_BracketLeft },
        { "Key_Backslash", TQt::Key_Backslash },
        { "Key_BracketRight", TQt::Key_BracketRight },
        { "Key_AsciiCircum", TQt::Key_AsciiCircum },
        { "Key_Underscore", TQt::Key_Underscore },
        { "Key_QuoteLeft", TQt::Key_QuoteLeft },
        { "Key_BraceLeft", TQt::Key_BraceLeft },
        { "Key_Bar", TQt::Key_Bar },
        { "Key_BraceRight", TQt::Key_BraceRight },
        { "Key_AsciiTilde", TQt::Key_AsciiTilde },
        { "Key_nobreakspace", TQt::Key_nobreakspace },
        { "Key_exclamdown", TQt::Key_exclamdown },
        { "Key_cent", TQt::Key_cent },
        { "Key_sterling", TQt::Key_sterling },
        { "Key_currency", TQt::Key_currency },
        { "Key_yen", TQt::Key_yen },
        { "Key_brokenbar", TQt::Key_brokenbar },
        { "Key_section", TQt::Key_section },
        { "Key_diaeresis", TQt::Key_diaeresis },
        { "Key_copyright", TQt::Key_copyright },
        { "Key_ordfeminine", TQt::Key_ordfeminine },
        { "Key_guillemotleft", TQt::Key_guillemotleft },
        { "Key_notsign", TQt::Key_notsign },
        { "Key_hyphen", TQt::Key_hyphen },
        { "Key_registered", TQt::Key_registered },
        { "Key_macron", TQt::Key_macron },
        { "Key_degree", TQt::Key_degree },
        { "Key_plusminus", TQt::Key_plusminus },
        { "Key_twosuperior", TQt::Key_twosuperior },
        { "Key_threesuperior", TQt::Key_threesuperior },
        { "Key_acute", TQt::Key_acute },
        { "Key_mu", TQt::Key_mu },
        { "Key_paragraph", TQt::Key_paragraph },
        { "Key_periodcentered", TQt::Key_periodcentered },
        { "Key_cedilla", TQt::Key_cedilla },
        { "Key_onesuperior", TQt::Key_onesuperior },
        { "Key_masculine", TQt::Key_masculine },
        { "Key_guillemotright", TQt::Key_guillemotright },
        { "Key_onequarter", TQt::Key_onequarter },
        { "Key_onehalf", TQt::Key_onehalf },
        { "Key_threequarters", TQt::Key_threequarters },
        { "Key_questiondown", TQt::Key_questiondown },
        { "Key_Agrave", TQt::Key_Agrave },
        { "Key_Aacute", TQt::Key_Aacute },
        { "Key_Acircumflex", TQt::Key_Acircumflex },
        { "Key_Atilde", TQt::Key_Atilde },
        { "Key_Adiaeresis", TQt::Key_Adiaeresis },
        { "Key_Aring", TQt::Key_Aring },
        { "Key_AE", TQt::Key_AE },
        { "Key_Ccedilla", TQt::Key_Ccedilla },
        { "Key_Egrave", TQt::Key_Egrave },
        { "Key_Eacute", TQt::Key_Eacute },
        { "Key_Ecircumflex", TQt::Key_Ecircumflex },
        { "Key_Ediaeresis", TQt::Key_Ediaeresis },
        { "Key_Igrave", TQt::Key_Igrave },
        { "Key_Iacute", TQt::Key_Iacute },
        { "Key_Icircumflex", TQt::Key_Icircumflex },
        { "Key_Idiaeresis", TQt::Key_Idiaeresis },
        { "Key_ETH", TQt::Key_ETH },
        { "Key_Ntilde", TQt::Key_Ntilde },
        { "Key_Ograve", TQt::Key_Ograve },
        { "Key_Oacute", TQt::Key_Oacute },
        { "Key_Ocircumflex", TQt::Key_Ocircumflex },
        { "Key_Otilde", TQt::Key_Otilde },
        { "Key_Odiaeresis", TQt::Key_Odiaeresis },
        { "Key_multiply", TQt::Key_multiply },
        { "Key_Ooblique", TQt::Key_Ooblique },
        { "Key_Ugrave", TQt::Key_Ugrave },
        { "Key_Uacute", TQt::Key_Uacute },
        { "Key_Ucircumflex", TQt::Key_Ucircumflex },
        { "Key_Udiaeresis", TQt::Key_Udiaeresis },
        { "Key_Yacute", TQt::Key_Yacute },
        { "Key_THORN", TQt::Key_THORN },
        { "Key_ssharp", TQt::Key_ssharp },
        { "Key_agrave", TQt::Key_agrave },
        { "Key_aacute", TQt::Key_aacute },
        { "Key_acircumflex", TQt::Key_acircumflex },
        { "Key_atilde", TQt::Key_atilde },
        { "Key_adiaeresis", TQt::Key_adiaeresis },
        { "Key_aring", TQt::Key_aring },
        { "Key_ae", TQt::Key_ae },
        { "Key_ccedilla", TQt::Key_ccedilla },
        { "Key_egrave", TQt::Key_egrave },
        { "Key_eacute", TQt::Key_eacute },
        { "Key_ecircumflex", TQt::Key_ecircumflex },
        { "Key_ediaeresis", TQt::Key_ediaeresis },
        { "Key_igrave", TQt::Key_igrave },
        { "Key_iacute", TQt::Key_iacute },
        { "Key_icircumflex", TQt::Key_icircumflex },
        { "Key_idiaeresis", TQt::Key_idiaeresis },
        { "Key_eth", TQt::Key_eth },
        { "Key_ntilde", TQt::Key_ntilde },
        { "Key_ograve", TQt::Key_ograve },
        { "Key_oacute", TQt::Key_oacute },
        { "Key_ocircumflex", TQt::Key_ocircumflex },
        { "Key_otilde", TQt::Key_otilde },
        { "Key_odiaeresis", TQt::Key_odiaeresis },
        { "Key_division", TQt::Key_division },
        { "Key_oslash", TQt::Key_oslash },
        { "Key_ugrave", TQt::Key_ugrave },
        { "Key_uacute", TQt::Key_uacute },
        { "Key_ucircumflex", TQt::Key_ucircumflex },
        { "Key_udiaeresis", TQt::Key_udiaeresis },
        { "Key_yacute", TQt::Key_yacute },
        { "Key_thorn", TQt::Key_thorn },
        { "Key_ydiaeresis", TQt::Key_ydiaeresis },
        { "Key_Back", TQt::Key_Back },
        { "Key_Forward", TQt::Key_Forward },
        { "Key_Stop", TQt::Key_Stop },
        { "Key_Refresh", TQt::Key_Refresh },
        { "Key_VolumeDown", TQt::Key_VolumeDown },
        { "Key_VolumeMute", TQt::Key_VolumeMute },
        { "Key_VolumeUp", TQt::Key_VolumeUp },
        { "Key_BassBoost", TQt::Key_BassBoost },
        { "Key_BassUp", TQt::Key_BassUp },
        { "Key_BassDown", TQt::Key_BassDown },
        { "Key_TrebleUp", TQt::Key_TrebleUp },
        { "Key_TrebleDown", TQt::Key_TrebleDown },
        { "Key_MediaPlay", TQt::Key_MediaPlay },
        { "Key_MediaStop", TQt::Key_MediaStop },
        { "Key_MediaPrev", TQt::Key_MediaPrev },
        { "Key_MediaNext", TQt::Key_MediaNext },
        { "Key_MediaRecord", TQt::Key_MediaRecord },
        { "Key_HomePage", TQt::Key_HomePage },
        { "Key_Favorites", TQt::Key_Favorites },
        { "Key_Search", TQt::Key_Search },
        { "Key_Standby", TQt::Key_Standby },
        { "Key_OpenUrl", TQt::Key_OpenUrl },
        { "Key_LaunchMail", TQt::Key_LaunchMail },
        { "Key_LaunchMedia", TQt::Key_LaunchMedia },
        { "Key_Launch0", TQt::Key_Launch0 },
        { "Key_Launch1", TQt::Key_Launch1 },
        { "Key_Launch2", TQt::Key_Launch2 },
        { "Key_Launch3", TQt::Key_Launch3 },
        { "Key_Launch4", TQt::Key_Launch4 },
        { "Key_Launch5", TQt::Key_Launch5 },
        { "Key_Launch6", TQt::Key_Launch6 },
        { "Key_Launch7", TQt::Key_Launch7 },
        { "Key_Launch8", TQt::Key_Launch8 },
        { "Key_Launch9", TQt::Key_Launch9 },
        { "Key_LaunchA", TQt::Key_LaunchA },
        { "Key_LaunchB", TQt::Key_LaunchB },
        { "Key_LaunchC", TQt::Key_LaunchC },
        { "Key_LaunchD", TQt::Key_LaunchD },
        { "Key_LaunchE", TQt::Key_LaunchE },
        { "Key_LaunchF", TQt::Key_LaunchF },
        { "Key_MediaLast", TQt::Key_MediaLast },
        { "Key_unknown", TQt::Key_unknown },
        // enum ArrowType
        { "UpArrow", TQt::UpArrow },
        { "DownArrow", TQt::DownArrow },
        { "LeftArrow", TQt::LeftArrow },
        { "RightArrow", TQt::RightArrow },
        // enum RasterOp
        { "CopyROP", TQt::CopyROP },
        { "OrROP", TQt::OrROP },
        { "XorROP", TQt::XorROP },
        { "NotAndROP", TQt::NotAndROP },
        { "EraseROP", TQt::EraseROP },
        { "NotCopyROP", TQt::NotCopyROP },
        { "NotOrROP", TQt::NotOrROP },
        { "NotXorROP", TQt::NotXorROP },
        { "AndROP", TQt::AndROP },
        { "NotEraseROP", TQt::NotEraseROP },
        { "NotROP", TQt::NotROP },
        { "ClearROP", TQt::ClearROP },
        { "SetROP", TQt::SetROP },
        { "NopROP", TQt::NopROP },
        { "AndNotROP", TQt::AndNotROP },
        { "OrNotROP", TQt::OrNotROP },
        { "NandROP", TQt::NandROP },
        { "NorROP", TQt::NorROP },
        { "LastROP", TQt::LastROP },
        // enum PenStyle
        { "NoPen", TQt::NoPen },
        { "SolidLine", TQt::SolidLine },
        { "DashLine", TQt::DashLine },
        { "DotLine", TQt::DotLine },
        { "DashDotLine", TQt::DashDotLine },
        { "DashDotDotLine", TQt::DashDotDotLine },
        { "MPenStyle", TQt::MPenStyle },
        // enum PenCapStyle
        { "FlatCap", TQt::FlatCap },
        { "SquareCap", TQt::SquareCap },
        { "RoundCap", TQt::RoundCap },
        { "MPenCapStyle", TQt::MPenCapStyle },
        // enum PenJoinStyle
        { "MiterJoin", TQt::MiterJoin },
        { "BevelJoin", TQt::BevelJoin },
        { "RoundJoin", TQt::RoundJoin },
        { "MPenJoinStyle", TQt::MPenJoinStyle },
        // enum BrushStyle
        { "NoBrush", TQt::NoBrush },
        { "SolidPattern", TQt::SolidPattern },
        { "Dense1Pattern", TQt::Dense1Pattern },
        { "Dense2Pattern", TQt::Dense2Pattern },
        { "Dense3Pattern", TQt::Dense3Pattern },
        { "Dense4Pattern", TQt::Dense4Pattern },
        { "Dense5Pattern", TQt::Dense5Pattern },
        { "Dense6Pattern", TQt::Dense6Pattern },
        { "Dense7Pattern", TQt::Dense7Pattern },
        { "HorPattern", TQt::HorPattern },
        { "VerPattern", TQt::VerPattern },
        { "CrossPattern", TQt::CrossPattern },
        { "BDiagPattern", TQt::BDiagPattern },
        { "FDiagPattern", TQt::FDiagPattern },
        { "DiagCrossPattern", TQt::DiagCrossPattern },
        { "CustomPattern", TQt::CustomPattern },
        // enum MacintoshVersion
        { "MV_Unknown", TQt::MV_Unknown },
        { "MV_9", TQt::MV_9 },
        { "MV_10_DOT_0", TQt::MV_10_DOT_0 },
        { "MV_10_DOT_1", TQt::MV_10_DOT_1 },
        { "MV_10_DOT_2", TQt::MV_10_DOT_2 },
        { "MV_10_DOT_3", TQt::MV_10_DOT_3 },
        { "MV_CHEETAH", TQt::MV_CHEETAH },
        { "MV_PUMA", TQt::MV_PUMA },
        { "MV_JAGUAR", TQt::MV_JAGUAR },
        { "MV_PANTHER", TQt::MV_PANTHER },
        // enum WindowsVersion
        { "WV_32s", TQt::WV_32s },
        { "WV_95", TQt::WV_95 },
        { "WV_98", TQt::WV_98 },
        { "WV_Me", TQt::WV_Me },
        { "WV_DOS_based", TQt::WV_DOS_based },
        { "WV_NT", TQt::WV_NT },
        { "WV_2000", TQt::WV_2000 },
        { "WV_XP", TQt::WV_XP },
        { "WV_2003", TQt::WV_2003 },
        { "WV_NT_based", TQt::WV_NT_based },
        { "WV_CE", TQt::WV_CE },
        { "WV_CENET", TQt::WV_CENET },
        { "WV_CE_based", TQt::WV_CE_based },
        // enum UIEffect
        { "UI_General", TQt::UI_General },
        { "UI_AnimateMenu", TQt::UI_AnimateMenu },
        { "UI_FadeMenu", TQt::UI_FadeMenu },
        { "UI_AnimateCombo", TQt::UI_AnimateCombo },
        { "UI_AnimateTooltip", TQt::UI_AnimateTooltip },
        { "UI_FadeTooltip", TQt::UI_FadeTooltip },
        { "UI_AnimateToolBox", TQt::UI_AnimateToolBox },
        // enum CursorShape
        { "ArrowCursor", TQt::ArrowCursor },
        { "UpArrowCursor", TQt::UpArrowCursor },
        { "CrossCursor", TQt::CrossCursor },
        { "WaitCursor", TQt::WaitCursor },
        { "IbeamCursor", TQt::IbeamCursor },
        { "SizeVerCursor", TQt::SizeVerCursor },
        { "SizeHorCursor", TQt::SizeHorCursor },
        { "SizeBDiagCursor", TQt::SizeBDiagCursor },
        { "SizeFDiagCursor", TQt::SizeFDiagCursor },
        { "SizeAllCursor", TQt::SizeAllCursor },
        { "BlankCursor", TQt::BlankCursor },
        { "SplitVCursor", TQt::SplitVCursor },
        { "SplitHCursor", TQt::SplitHCursor },
        { "PointingHandCursor", TQt::PointingHandCursor },
        { "ForbiddenCursor", TQt::ForbiddenCursor },
        { "WhatsThisCursor", TQt::WhatsThisCursor },
        { "BusyCursor", TQt::BusyCursor },
        { "LastCursor", TQt::LastCursor },
        { "BitmapCursor", TQt::BitmapCursor },
        // enum TextFormat
        { "PlainText", TQt::PlainText },
        { "RichText", TQt::RichText },
        { "AutoText", TQt::AutoText },
        { "LogText", TQt::LogText },
        // enum AnchorAttribute
        { "AnchorName", TQt::AnchorName },
        { "AnchorHref", TQt::AnchorHref },
        // enum Dock
        { "DockUnmanaged", TQt::DockUnmanaged },
        { "DockTornOff", TQt::DockTornOff },
        { "DockTop", TQt::DockTop },
        { "DockBottom", TQt::DockBottom },
        { "DockRight", TQt::DockRight },
        { "DockLeft", TQt::DockLeft },
        { "DockMinimized", TQt::DockMinimized },
        { "Unmanaged", TQt::Unmanaged },
        { "TornOff", TQt::TornOff },
        { "Top", TQt::Top },
        { "Bottom", TQt::Bottom },
        { "Right", TQt::Right },
        { "Left", TQt::Left },
        { "Minimized", TQt::Minimized },
        // enum DateFormat
        { "TextDate", TQt::TextDate },
        { "ISODate", TQt::ISODate },
        { "LocalDate", TQt::LocalDate },
        // enum TimeSpec
        { "LocalTime", TQt::LocalTime },
        { "UTC", TQt::UTC },
        // enum BackgroundMode
        { "FixedColor", TQt::FixedColor },
        { "FixedPixmap", TQt::FixedPixmap },
        { "NoBackground", TQt::NoBackground },
        { "PaletteForeground", TQt::PaletteForeground },
        { "PaletteButton", TQt::PaletteButton },
        { "PaletteLight", TQt::PaletteLight },
        { "PaletteMidlight", TQt::PaletteMidlight },
        { "PaletteDark", TQt::PaletteDark },
        { "PaletteMid", TQt::PaletteMid },
        { "PaletteText", TQt::PaletteText },
        { "PaletteBrightText", TQt::PaletteBrightText },
        { "PaletteBase", TQt::PaletteBase },
        { "PaletteBackground", TQt::PaletteBackground },
        { "PaletteShadow", TQt::PaletteShadow },
        { "PaletteHighlight", TQt::PaletteHighlight },
        { "PaletteHighlightedText", TQt::PaletteHighlightedText },
        { "PaletteButtonText", TQt::PaletteButtonText },
        { "PaletteLink", TQt::PaletteLink },
        { "PaletteLinkVisited", TQt::PaletteLinkVisited },
        { "X11ParentRelative", TQt::X11ParentRelative },
        // enum StringComparisonMode
        { "CaseSensitive", TQt::CaseSensitive },
        { "BeginsWith", TQt::BeginsWith },
        { "EndsWith", TQt::EndsWith },
        { "Contains", TQt::Contains },
        { "ExactMatch", TQt::ExactMatch },
        // enum Corner
        { "TopLeft", TQt::TopLeft },
        { "TopRight", TQt::TopRight },
        { "BottomLeft", TQt::BottomLeft },
        { "BottomRight", TQt::BottomRight },
	{ 0, 0 }
    };

    int enumidx = 0;
    while( enums[enumidx].id ) {
        object.put( exec, enums[enumidx].id, KJS::Number(enums[enumidx].val), KJS::ReadOnly );
        ++enumidx;
    }

}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QtImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QtImp *meth = new QtImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQt pointer from an Object.
 */
TQt *QtImp::toTQt( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQt *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "Qt" )
        return 0;

    return op->toNative<TQt>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QtImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         default:
             break;
    }

    TQString msg = i18n("QtCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value QtImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QtImp::toTQt( self );

    switch( id ) {

    default:
        break;
    }

    TQString msg = i18n( "QtImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}



} // namespace KJSEmbed
