/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;


class MDIWindow extends TQMainWindow
{

private    TQMultiLineEdit medit;
private    TQMovie  mmovie;
private    String filename = "";

MDIWindow( TQWidget parent, String name, int wflags )
{
    super( parent, name, wflags );
    mmovie = null;
    medit = new TQMultiLineEdit( this );
    setFocusProxy( medit );
    setCentralWidget( medit );
}


void load( String fn )
{
    filename  = fn;
    TQFile f = new TQFile( filename );
    if ( !f.open( TQIODevice.IO_ReadOnly ) )
	return;

    if(fn.indexOf(".gif") != -1) {
	TQWidget  tmp=new TQWidget(this);
	setFocusProxy(tmp);
	setCentralWidget(tmp);
	medit.hide();
	TQMovie  qm=new TQMovie(fn);
//	qm.setDisplayWidget(tmp);
	tmp.setBackgroundMode(TQWidget.NoBackground);
	tmp.show();
	mmovie=qm;
    } else {
	mmovie = null;

	TQTextStream t = new TQTextStream(f);
	String s = t.read();
	medit.setText( s );
	f.close();


    }
    setCaption( filename );
    emit("message", "Loaded document " + filename, 2000 );
}

void save()
{
    if ( filename.equals("") ) {
        saveAs();
        return;
    }

    String text = medit.text();
    TQFile f = new TQFile( filename );
    if ( !f.open( TQIODevice.IO_WriteOnly ) ) {
        emit("message", "Could not write to " + filename,
		      2000 );
        return;
    }

    TQTextStream t = new TQTextStream( f );
	t.writeRawBytes( text, text.length() );
    f.close();

    setCaption( filename );

    emit("message", "File " + filename + " saved", 2000 );
}

void saveAs()
{
    String fn = TQFileDialog.getSaveFileName( filename, "", this );
    if ( !fn.equals("") ) {
        filename = fn;
        save();
    } else {
        emit("message", "Saving aborted", 2000 );
    }
}

void print( TQPrinter printer)
{
    int Margin = 10;
    int pageNo = 1;

    if ( printer.setup(this) ) {		// printer dialog
	emit("message", "Printing...", 0 );
	TQPainter p = new TQPainter();
	if ( !p.begin( printer ) )
	    return;				// paint on printer
	p.setFont( medit.font() );
	int yPos        = 0;			// y position for each line
	TQFontMetrics fm = p.fontMetrics();
	TQPaintDeviceMetrics metrics = new TQPaintDeviceMetrics( printer ); // need width/height
	// of printer surface
	for( int i = 0 ; i < medit.numLines() ; i++ ) {
	    if ( Margin + yPos > metrics.height() - Margin ) {
		String msg = "Printing (page ";
		msg += (++pageNo);
		msg += ")...";
		emit("message", msg, 0 );
		printer.newPage();		// no more room on this page
		yPos = 0;			// back to top of page
	    }
	    p.drawText( Margin, Margin + yPos,
			metrics.width(), fm.lineSpacing(),
			ExpandTabs | DontClip,
			medit.textLine( i ) );
	    yPos = yPos + fm.lineSpacing();
	}
	p.end();				// send job to printer
	emit("message", "Printing completed", 2000 );
    } else {
	emit("message", "Printing aborted", 2000 );
    }
}

}

