
import org.trinitydesktop.qt.*;

class MoveMe  extends TQWidget
{
public    MoveMe( TQWidget parent, String name, int f)
{
	super(parent,name, f);
}

private    TQPoint clickPos;

protected void mousePressEvent( TQMouseEvent e )
{
    //    if ( e.button() == LeftButton )
	clickPos = e.pos();
}

protected void mouseMoveEvent( TQMouseEvent e )
{
    //    if ( e.state() & LeftButton )
	move( new TQPoint( e.globalPos().x() - clickPos.x(),
	                  e.globalPos().y() - clickPos.y() ) );
}



public static void main(String[] args)
{
    TQApplication a = new TQApplication( args );

    String fn="tux.png";

    if ( args.length >= 1 )
	fn = args[0];

    if ( ! TQFile.exists( fn ) )
	System.exit( 1 );

    TQImage img = new TQImage( fn );
    TQPixmap p = new TQPixmap();
    p.convertFromImage( img );
    if ( p.mask() == null )
	if ( img.hasAlphaBuffer() ) {
	    TQBitmap bm = new TQBitmap(img.createAlphaMask());
	    p.setMask( bm );
	} else {
	    TQBitmap bm = new TQBitmap(img.createHeuristicMask());
	    p.setMask( bm );
	}
    MoveMe w = new MoveMe(null,null,Qt.WStyle_Customize|Qt.WStyle_NoBorder);
    w.setBackgroundPixmap( p );
    w.setFixedSize( p.size() );
    if ( p.mask() != null )
	w.setMask( p.mask() );
    w.show();
    a.setMainWidget(w);


    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}

}
