import org.trinitydesktop.qt.*;

public class Tut7 extends TQVBox {
	public Tut7() {
		TQPushButton quit = new TQPushButton("Quit", this, "quit");
		quit.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(quit, TQ_SIGNAL("clicked()"), tqApp(), TQ_SLOT("quit()"));

		TQGrid grid = new TQGrid(4, this, null, 0);
		
		LCDRange previous = null;
		for(int r = 0; r < 4; r++) {
			for(int c = 0; c < 4; c++) {
				LCDRange lr = new LCDRange(grid);
				if (previous!=null)
					connect(lr, TQ_SIGNAL("valueChanged(int)"),
									previous, TQ_SLOT("setValue(int)"));
				previous = lr;
			}
		}
	}
	
	public static void main(String[] args) {
		TQApplication a = new TQApplication(args);
		Tut7 w = new Tut7();
		
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.trinitydesktop.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
