// TQToolButton.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// Created static file 26 January 2003
// Marcus Urban


namespace Qt {

	using Qt;
	using System;
	using System.Runtime.InteropServices;

	public class TQToolButton : TQButton, IDisposable {

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QToolButton (IntPtr parent, string name);
		public TQToolButton (TQWidget parent, string name) : this (TQNull.Instance)
		{
			rawObject = qt_new_QToolButton (parent != null ? parent.RawObject : IntPtr.Zero, name);

			if ((qparent = parent) != null)
				qparent.AddChild (this);

			RegisterObject (this);
			Connect (this, TQ_SIGNAL ("destroyed ()"), TQ_SLOT ("NativeDestroyed ()"));
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QToolButton1 (IntPtr iconSet, IntPtr textLabel, IntPtr groupText, IntPtr receiver, string slot, IntPtr parent, string name);
		public TQToolButton (TQIconSet iconSet, TQString textLabel, TQString groupText, TQObject receiver, string slot, TQToolBar parent, string name) : this (TQNull.Instance)
		{
			rawObject = qt_new_QToolButton1 (iconSet.RawObject, textLabel.RawObject, groupText.RawObject, IntPtr.Zero, null, parent != null ? parent.RawObject : IntPtr.Zero, name);
			Connect( this, TQ_SIGNAL("clicked()"), receiver, slot );
			
			
			if ((qparent = parent) != null)
				qparent.AddChild (this);

			RegisterObject (this);
			Connect (this, TQ_SIGNAL ("destroyed ()"), TQ_SLOT ("NativeDestroyed ()"));
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QToolButton2 (Qt.ArrowType type, IntPtr parent, string name);
		public TQToolButton (Qt.ArrowType type, TQWidget parent, string name) : this (TQNull.Instance)
		{
			rawObject = qt_new_QToolButton2 (type, parent != null ? parent.RawObject : IntPtr.Zero, name);

			if ((qparent = parent) != null)
				qparent.AddChild (this);

			RegisterObject (this);
			Connect (this, TQ_SIGNAL ("destroyed ()"), TQ_SLOT ("NativeDestroyed ()"));
		}

		public TQToolButton (TQWidget parent) : this (parent, "") {}

		internal TQToolButton () : this (TQNull.Instance) {}

		internal TQToolButton (IntPtr ptr) : this (TQNull.Instance)
		{
			rawObject = ptr;
			RegisterObject(this);
		}

		internal TQToolButton (TQNull dummy) : base (TQNull.Instance) {}

		~TQToolButton ()
		{
			Dispose (false);
		}

		internal override void Delete ()
		{
			if (deleted) return;

			// libtqtc lacks a qt_del_QToolButton function
			deleted = true;
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setUsesBigPixmap (IntPtr raw, bool enable);
		public void SetUsesBigPixmap (bool enable)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setUsesBigPixmap (rawObject, enable);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setUsesTextLabel (IntPtr raw, bool enable);
		public void SetUsesTextLabel (bool enable)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setUsesTextLabel (rawObject, enable);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setTextLabel (IntPtr raw, IntPtr arg1, bool arg2);
		public void SetTextLabel (TQString arg1, bool arg2)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setTextLabel (rawObject, arg1.RawObject, arg2);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setToggleButton (IntPtr raw, bool enable);
		public void SetToggleButton (bool enable)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setToggleButton (rawObject, enable);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setOn (IntPtr raw, bool enable);
		public void SetOn (bool enable)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setOn (rawObject, enable);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_toggle (IntPtr raw);
		public void Toggle ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_toggle (rawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setTextLabel1 (IntPtr raw, IntPtr arg1);
		public void SetTextLabel (TQString arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setTextLabel1 (rawObject, arg1.RawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setIconSet (IntPtr raw, IntPtr set);
		public void SetIconSet (TQIconSet set)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setIconSet (rawObject, set.RawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setPopupDelay (IntPtr raw, int delay);
		public void SetPopupDelay (int delay)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setPopupDelay (rawObject, delay);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QToolButton_popupDelay (IntPtr raw);
		public int PopupDelay ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QToolButton_popupDelay (rawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_openPopup (IntPtr raw);
		public void OpenPopup ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_openPopup (rawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_setAutoRaise (IntPtr raw, bool enable);
		public void SetAutoRaise (bool enable)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_setAutoRaise (rawObject, enable);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QToolButton_autoRaise (IntPtr raw);
		public bool AutoRaise ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QToolButton_autoRaise (rawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_drawButtonLabel (IntPtr raw, IntPtr arg1);
		protected void DrawButtonLabel (TQPainter arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_drawButtonLabel (rawObject, arg1.RawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QToolButton_uses3D (IntPtr raw);
		protected bool Uses3D ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QToolButton_uses3D (rawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QToolButton_eventFilter (IntPtr raw, IntPtr o, IntPtr e);
		protected bool EventFilter (TQObject o, TQEvent e)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QToolButton_eventFilter (rawObject, o.RawObject, e.RawObject);
		}

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QToolButton_paletteChange (IntPtr raw, IntPtr arg1);
		protected void PaletteChange (TQPalette arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QToolButton_paletteChange (rawObject, arg1.RawObject);
		}

		// Begin interface methods.

	}
}
