/* -------------------------------------------------------------------------
   -- kmahjongg timer. Based on a slightly modified verion of the QT demo --
   -- program dclock. Copyright as shown below.                           --
   ------------------------------------------------------------------------- */

/****************************************************************************
** $Id$
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef KM_GAME_TIMER 
#define KM_GAME_TIMER 

#include <tqlcdnumber.h>
#include <tqdatetime.h>

enum TimerMode {running = -53 , stopped= -54 , paused = -55};

class GameTimer: public TQLCDNumber 
{
    TQ_OBJECT
  
public:
    GameTimer( TQWidget *parent=0, const char *name=0 );

    int toInt(); 
    TQString toString() {return theTimer.toString();}	
    void fromString(const char *);

protected:					// event handlers
    void	timerEvent( TQTimerEvent * );
 
public slots:
    void start();
    void stop();
    void pause();


private slots:					// internal slots
    void	showTime();

private:					// internal data
    bool	showingColon;
    TQTime	theTimer;
    TimerMode   timerMode;
};


#endif 
