#################################################
#
#  (C) 2012 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#################################################

# required stuff
tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check specific architecture dependant support

if( CMAKE_SYSTEM_PROCESSOR MATCHES "i.86" )

  # MMX support
  message( STATUS "Performing MMX support test" )
  cmake_host_system_information( RESULT HAVE_X86_MMX QUERY HAS_MMX )
  if( HAVE_X86_MMX )
    message( STATUS "Performing MMX support test - Success" )
    set( CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} -DHAVE_X86_MMX" )
  endif( )

  # SSE support
	message( STATUS "Performing SSE support test" )
  cmake_host_system_information( RESULT HAVE_X86_SSE QUERY HAS_SSE )
  if( HAVE_X86_SSE )
		message( STATUS "Performing SSE support test - Success" )
    set( CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} -DHAVE_X86_SSE" )
  endif( )

endif( )

message( STATUS "Cheking system type - ${CMAKE_SYSTEM_NAME}" )
if( ${CMAKE_SYSTEM_NAME} MATCHES "AIX" )
  set( OS_AIX 1 )
elseif( ${CMAKE_SYSTEM_NAME} MATCHES "Linux" )
  set( OS_Linux 1 )
elseif( ${CMAKE_SYSTEM_NAME} MATCHES "OpenBSD|FreeBSD|DragonFly|NetBSD" )
  set( OS_BSD 1 )
elseif( ${CMAKE_SYSTEM_NAME} MATCHES "SunOS" )
  set( OS_SunOS 1 )
elseif( ${CMAKE_SYSTEM_NAME} MATCHES "IRIX" )
  set( OS_IRIX 1 )
elseif( ${CMAKE_SYSTEM_NAME} MATCHES "HPUX" )
  set( OS_HPUX 1 )
else( )
  message( WARNING "Unknown system type!" )
endif( )

find_package( TQt )
find_package( TDE )


##### check headers #############################

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( inttypes.h HAVE_INTTYPES_H )
check_include_file( getopt.h HAVE_GETOPT_H )
check_include_file( pthread.h HAVE_LIBPTHREAD )

check_include_file( alsa/asoundlib.h HAVE_ALSA_ASOUNDLIB_H )
check_include_file( sys/asoundlib.h HAVE_SYS_ASOUNDLIB_H )
check_include_file( soundcard.h HAVE_SOUNDCARD_H )
check_include_file( sys/soundcard.h HAVE_SYS_SOUNDCARD_H )
check_include_file( machine/soundcard.h HAVE_MACHINE_SOUNDCARD_H )


# ALSA
if( WITH_ALSA )
  pkg_check_modules( ALSA alsa>=0.5 )
  if( NOT ALSA_FOUND )
    tde_message_fatal( "ALSA support is requested, but was not found on your system" )
  endif( NOT ALSA_FOUND )
  if( NOT ALSA_VERSION VERSION_LESS "0.9" )
    set( HAVE_LIBASOUND2 1 )
    set( HAVE_ARTS_LIBASOUND2 1 )
  else()
    set( HAVE_ARTS_LIBASOUND 1 )
  endif()
endif( WITH_ALSA )


# aRts
if( BUILD_ARTS OR BUILD_JUK OR BUILD_KABOODLE OR BUILD_KREC OR BUILD_NOATUN )
  pkg_search_module( ARTS arts )
  if( ARTS_FOUND )
    set( ARTS_MCOPIDL_EXECUTABLE ${ARTS_PREFIX}/bin/mcopidl )
    set( HAVE_ARTS 1 )
  else( ARTS_FOUND )
    tde_message_fatal( "aRts is required, but not found on your system" )
  endif( ARTS_FOUND )
endif( BUILD_ARTS OR BUILD_JUK OR BUILD_KABOODLE OR BUILD_KREC OR BUILD_NOATUN )

if( BUILD_KAUDIOCREATOR OR BUILD_KREC OR BUILD_KSCD OR (BUILD_TDEIOSLAVE AND WITH_CDPARANOIA) )
  pkg_search_module( ARTSC artsc )
  if( NOT ARTSC_FOUND )
    tde_message_fatal( "aRtsC is required, but not found on your system" )
  endif( NOT ARTSC_FOUND )
endif( BUILD_KAUDIOCREATOR OR BUILD_KREC OR BUILD_KSCD OR (BUILD_TDEIOSLAVE AND WITH_CDPARANOIA) )

if( (BUILD_ARTS AND WITH_ARTS_AKODE) OR BUILD_JUK )
  pkg_search_module( AKODE akode )
  if( NOT AKODE_FOUND )
    tde_message_fatal( "akode is required, but not found on your system" )
  endif( )
  set( HAVE_AKODE 1 )
endif( (BUILD_ARTS AND WITH_ARTS_AKODE) OR BUILD_JUK )


if( BUILD_ARTS )

  pkg_search_module( GLIB2 glib-2.0 )
  if( GLIB2_FOUND )
    pkg_search_module( GTHREAD2 gthread-2.0 )
    if( NOT GTHREAD2_FOUND )
      tde_message_fatal( "gthread-2.0 are required, but not found on your system" )
    endif( NOT GTHREAD2_FOUND )
  else( GLIB2_FOUND )
    tde_message_fatal( "glib-2.0 are required, but not found on your system" )
  endif( GLIB2_FOUND )

  if( WITH_ARTS_AUDIOFILE )
    pkg_search_module( AUDIOFILE audiofile )
    if( NOT AUDIOFILE_FOUND )
      tde_message_fatal( "audifile is requested, but not found on your system" )
    endif( )
  endif( WITH_ARTS_AUDIOFILE )

  if( WITH_ARTS_XINE )
    pkg_search_module( XINE libxine )
    pkg_search_module( XEXT xext )
    if( NOT XINE_FOUND )
      tde_message_fatal( "xine is requested, but not found on your system" )
    endif( )
  endif( WITH_ARTS_XINE )

endif( BUILD_ARTS )


# CDDA Paranoia
if( WITH_CDPARANOIA )
  if( CDPARANOIA_INCLUDE_DIR AND CDPARANOIA_LIBRARIES )
    set( CDPARANOIA_FOUND TRUE )
  else( )
    message( STATUS "Checking for CDParanonia" )
    find_path( CDPARANOIA_INCLUDE_DIR cdda_interface.h PATH_SUFFIXES cdda )
    find_library( CDPARANOIA_LIBRARY NAMES cdda_paranoia )
    find_library( CDPARANOIA_IF_LIBRARY NAMES cdda_interface )
    if( CDPARANOIA_LIBRARY AND CDPARANOIA_IF_LIBRARY )
      set( CDPARANOIA_LIBRARIES ${CDPARANOIA_LIBRARY} ${CDPARANOIA_IF_LIBRARY} "m" CACHE INTERNAL "" FORCE )
    endif( CDPARANOIA_LIBRARY AND CDPARANOIA_IF_LIBRARY )

    include(FindPackageHandleStandardArgs)
    find_package_handle_standard_args( CDPARANOIA DEFAULT_MSG
                                       CDPARANOIA_LIBRARIES
                                       CDPARANOIA_INCLUDE_DIR )

    if( CDPARANOIA_FOUND )
      tde_save_and_set( CMAKE_REQUIRED_INCLUDES ${CDPARANOIA_INCLUDE_DIR} )
      check_c_source_compiles( "
        #include <cdda_interface.h>
        int main() {
            struct cdrom_drive device;
            device.cdda_device_name = 0;
            return 0;
        }"
        CDPARANOIA_DEVICE_NAME )
      tde_restore( CMAKE_REQUIRED_INCLUDES )
      if( NOT CDPARANOIA_DEVICE_NAME )
        tde_message_fatal( "CDParanoia is too old and can not be used" )
      endif( )
    endif( CDPARANOIA_FOUND )
  endif( )

  if( NOT CDPARANOIA_FOUND )
    tde_message_fatal( "CDParanoia is requested, but not found on your system" )
  endif( NOT CDPARANOIA_FOUND )
  set( CDDA_PARANOIA 1 )
endif( WITH_CDPARANOIA )


# FLAC
if( WITH_FLAC )
  pkg_search_module( FLAC flac )
  if( NOT FLAC_FOUND )
    find_library( FLAC_LIBRARIES NAMES FLAC FLAC++ OggFLAC OggFLAC++)
    if( NOT FLAC_LIBRARIES )
      tde_message_fatal( "FLAC is requested, but not found on your system" )
    endif( )
  endif( )
  set( HAVE_LIBFLAC 1 )
endif( WITH_FLAC )


# OGG/Vorbis
if( WITH_VORBIS )

  pkg_search_module( OGG ogg )
  if( NOT OGG_FOUND )
    tde_message_fatal( "Ogg/Vorbis support are requested, but `libogg` not found" )
  endif( )

  pkg_search_module( VORBIS vorbis )
  if( NOT VORBIS_FOUND )
    tde_message_fatal( "Ogg/Vorbis support are requested, but `libvorbis` not found" )
  endif( )

  pkg_search_module( VORBISFILE vorbisfile )
  if( NOT VORBISFILE_FOUND )
    tde_message_fatal( "Ogg/Vorbis support are requested, but `libvorbisfile` not found" )
  endif( )

  pkg_search_module( VORBISENC vorbisenc )
  if( NOT VORBISENC_FOUND )
    tde_message_fatal( "Ogg/Vorbis support are requested, but `libvorbisenc` not found" )
  endif( )

  check_library_exists( vorbis vorbis_bitrate_addblock "${VORBIS_LIBRARY_DIRS}" HAVE_VORBIS_2 )
  if( HAVE_VORBIS_2 )
    set( HAVE_VORBIS 2 )
  else( )
    set( HAVE_VORBIS 1 )
  endif( )
  set( OGG_VORBIS 1 )

endif( WITH_VORBIS )


# LAME
if( WITH_LAME )

  check_include_file( lame/lame.h HAVE_LAME_H )
  if( NOT HAVE_LAME_H )
    tde_message_fatal( "lame is requested, but not found on your system" )
  endif( )
  check_library_exists( mp3lame lame_init "" HAVE_LAME )
  if( NOT HAVE_LAME )
    tde_message_fatal( "mp3lame is requested, but not found on your system" )
  endif( )
  set( LAME_LIBRARIES mp3lame CACHE INTERNAL "" FORCE )

endif( WITH_LAME )


# taglib
if( BUILD_JUK OR WITH_TAGLIB )

  pkg_search_module( TAGLIB taglib )
  if( NOT TAGLIB_FOUND )
    tde_message_fatal( "taglib is required, but not found on your system" )
  endif( NOT TAGLIB_FOUND )

  tde_save_and_set( CMAKE_REQUIRED_INCLUDES ${TAGLIB_INCLUDE_DIRS} )
  check_include_file_cxx( taglib/mpcfile.h HAVE_TAGLIB_MPC_H )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

endif( BUILD_JUK OR WITH_TAGLIB )
