#ifndef KMIXTOOLBOX_H
#define KMIXTOOLBOX_H

#include "tqptrlist.h"
#include "tqwidget.h"

class Mixer;

class TDEConfig;

/**
 * This toolbox contains various static methods that are shared throughout KMix.
 * The reason, why it is not put in a common base class is, that the classes are
 * very different and cannot be changed (e.g. KPanelApplet) without major headache.
 */

class KMixToolBox {
 public:
    static void setIcons  (TQPtrList<TQWidget> &mdws, bool on );
    static void setLabels (TQPtrList<TQWidget> &mdws, bool on );
    static void setTicks  (TQPtrList<TQWidget> &mdws, bool on );
    static void setValueStyle  (TQPtrList<TQWidget> &mdws, int vs );
    static void loadConfig(TQPtrList<TQWidget> &mdws, TDEConfig *config, const TQString &grp, const TQString &viewPrefix  );
    static void saveConfig(TQPtrList<TQWidget> &mdws, TDEConfig *config, const TQString &grp, const TQString &viewPrefix  );
};
    

#endif
