#ifndef _NOATUNSTDACTION_H_
#define _NOATUNSTDACTION_H_

#include <tdeaction.h>
#include <tdeactionclasses.h>
#include <tdemacros.h>
class TDEPopupMenu;

/**
 * Holds all noatun related actions
 * @short noatun specific actions
 * @author Charles Samuels
 **/
namespace NoatunStdAction
{

/**
 * An action starting noatun playback
 **/
class PlayAction : public TDEAction
{
TQ_OBJECT
  
public:
	PlayAction(TQObject *parent, const char *name);
private slots:
	void playing();
	void notplaying();
};

/**
 * An action starting/stopping noatun playback
 **/
class PlaylistAction : public TDEToggleAction
{
TQ_OBJECT
  
public:
	PlaylistAction(TQObject *parent, const char *name);
private slots:
	void shown();
	void hidden();
};

/**
 * actionmenu that holds all plugin defined actions
 * @author Stefan Gehn
 */
class PluginActionMenu : public TDEActionMenu
{
TQ_OBJECT
  
public:
	PluginActionMenu(TQObject *parent, const char *name);
	/**
	 * inserts the given @p action into the action-menu
	 * @param action the action to insert
	 * @param index defines the place where the action gets displayed in
	 */
	virtual void insert (TDEAction *action, int index=-1);
	/**
	 * removes the given @p action into the action-menu
	 */
	virtual void remove(TDEAction *action);
	/**
	 * Wrapper method for old Noatun API
	 * <b>DON'T USE</b>
	 **/
	int menuAdd(const TQString &text, const TQObject *receiver, const char *member);
	/**
	 * Wrapper method for old Noatun API
	 * <b>DON'T USE</b>
	 **/
	void menuRemove(int id);
private:
	int mCount;
};

/**
 * actionmenu that holds all vis-plugins for easier enabling/disabling
 * @author Stefan Gehn
 */
class VisActionMenu : public TDEActionMenu
{
TQ_OBJECT
  
public:
	VisActionMenu(TQObject *parent, const char *name);
private slots:
	void fillPopup();
	void toggleVisPlugin(int);
private:
	TQMap<int, TQString>mSpecMap;
};


/**
 * actionmenu that holds all looping modes
 * @author Stefan Gehn
 */
class LoopActionMenu : public TDEActionMenu
{
TQ_OBJECT
  
public:
	LoopActionMenu(TQObject *parent, const char *name);
private slots:
	void updateLooping(int);
	void loopNoneSelected();
	void loopSongSelected();
	void loopPlaylistSelected();
	void loopRandomSelected();
private:
	TDERadioAction *mLoopNone;
	TDERadioAction *mLoopSong;
	TDERadioAction *mLoopPlaylist;
	TDERadioAction *mLoopRandom;
};


/**
 * @return pointer to a TDEAction which opens the effects dialog on activation
 */
TDE_EXPORT TDEAction *effects(TQObject *parent = 0, const char *name = 0);

/**
 * @return pointer to a TDEAction which opens the equalizer dialog on activation
 */
TDE_EXPORT TDEAction *equalizer(TQObject *parent = 0, const char *name = 0);

/**
 * @return pointer to a TDEAction which goes back one track on activation
 */
TDE_EXPORT TDEAction *back(TQObject *parent = 0, const char *name = 0);
/**
 * @return pointer to a TDEAction which stops playback on activation
 */
TDE_EXPORT TDEAction *stop(TQObject *parent = 0, const char *name = 0);
/**
 * @return pointer to a TDEAction which starts/pauses playback on activation
 */
TDE_EXPORT TDEAction *playpause(TQObject *parent = 0, const char *name = 0);
/**
 * @return pointer to a TDEAction which advances one track on activation
 */
TDE_EXPORT TDEAction *forward(TQObject *parent = 0, const char *name = 0);
/**
 * @return pointer to a TDEToggleAction which shows/hides the playlist
 */
TDE_EXPORT TDEToggleAction *playlist(TQObject *parent = 0, const char *name = 0);

/**
 * loop action
 **/
TDE_EXPORT LoopActionMenu *loop(TQObject *parent, const char *name);

/**
 * play action
 */
TDE_EXPORT TDEAction *play(TQObject *parent = 0, const char *name = 0);

/**
 * pause action
 */
TDE_EXPORT TDEAction *pause(TQObject *parent = 0, const char *name = 0);

/**
 * @return pointer to the global PluginActionMenu object (there is only one instance)
 */
TDE_EXPORT PluginActionMenu *actions();

/**
 * @return pointer to a VisActionMenu object
 */
TDE_EXPORT VisActionMenu *visualizations(TQObject *parent = 0, const char *name = 0);

/**
 * The global popupmenu of noatun, there's not two or three but only one of these :)
 * @author Charles Samuels
 **/
class TDE_EXPORT ContextMenu
{
public:
	static TDEPopupMenu *createContextMenu(TQWidget *p);

	/**
	 * One menu to show them all, One menu to find them
	 * One menu to bring them all and in the darkness bind them
	 *
	 * In the land of Noatun where the oceans die
	 */
	static TDEPopupMenu *contextMenu();

	/**
	 * Show the context menu at point
	 **/
	static void showContextMenu(const TQPoint &);

	/**
	 * show the context menu at the mouse's current position
	 **/
	static void showContextMenu();
private:
	static TDEPopupMenu *mContextMenu;
};

}

#endif
