// Convert Noatun 1.2 plugins that no longer exist to their closest 2.0
// counterparts.

#include <tqfile.h>
#include <tqregexp.h>

#ifndef stdin
extern "C" FILE *stdin;
#endif

#ifndef stdout
extern "C" FILE *stdout;
#endif

int main(int, char **)
{
	TQFile qin, qout;
	qin.open(IO_ReadOnly, stdin);
	qout.open(IO_WriteOnly, stdout);

	TQString text = qin.readAll();

	// tag loaders
	bool tagloaders = text.contains("id3tag.plugin") ||
	                  text.contains("oggtag.plugin") ||
	                  text.contains("luckytag.plugin");

	text.replace(TQRegExp("id3tag\\.plugin"), "");
	text.replace(TQRegExp("oggtag\\.plugin"), "");
	text.replace(TQRegExp("luckytag\\.plugin"), "");

	if(tagloaders) text.replace(TQRegExp("Modules="), "Modules=metatag.plugin,");

	// playlists
	text.replace(TQRegExp("tron\\.plugin"), "splitplaylist.plugin");
	text.replace(TQRegExp("liszt\\.plugin"), "splitplaylist.plugin");

	qout.writeBlock(text.local8Bit());

	return 0;
}
