/* mode buttons for ksirc - Robbie Ward <linuxphreak@gmx.co.uk>*/

#ifndef CHANBUTTONS_H
#define CHANBUTTONS_H

#include <tqwidget.h>
#include <tqpushbutton.h>
#include <kdialog.h>

class TQHBoxLayout;
class TQVBoxLayout;
class TDEPopupMenu;
class chanbuttonsDialog;
class KIntSpinBox;
class TQLineEdit;
class KSircProcess;
class KPushButton;

class chanButtons : public TQWidget
{
  TQ_OBJECT
  
  friend class KSircTopLevel;
  public:
    chanButtons(KSircProcess *proc, TQWidget* parent=0, const char* name=0);
    ~chanButtons() {};

    void setProtectMode(bool value) { protectButton->setOn(value); }
    void setModerateMode(bool value) { moderateButton->setOn(value); }
    void setNooutsideMode(bool value) { outsideButton->setOn(value); }
    void setButtonsEnabled(bool);
    void setMenuItemMode(int, bool);

  signals:
    void mode(TQString, int, TQString nick = TQString());  /// int == 0 channel mode, int == 1 user nick mode

  private slots:
    void protectMode();
    void outsideMode();
    void moderateMode();
    void invite();
    void limited();
    void key();
    void secret();
    void invisible();
    void wallops();
    void serverNotices();

  private:
    int toggleMenu[7];
    TQHBoxLayout *layout;
    TQPushButton *protectButton;
    TQPushButton *moderateButton;
    TQPushButton *outsideButton;
    TQPushButton *menuButton;
    TDEPopupMenu *Popupmenu;
    chanbuttonsDialog *chanDialog;
    KSircProcess *m_proc;
};

class chanbuttonsDialog : public KDialog
{
  TQ_OBJECT
  
  friend class chanButtons;
  public:
    enum type { limited, key };
    chanbuttonsDialog(const type &modeType, TQWidget *parent=0, const char *name=0, bool modal=true);
    ~chanbuttonsDialog() {};

  private slots:
    void keyString();
    void limitedUsers();
    TQString sendKey() { return m_sendKey; }
    int sendLimitedUsers() { return m_sendLimitedUsers; };

  private:
    TQString m_sendKey;
    int m_sendLimitedUsers;
    TQVBoxLayout *LimitedLayout;
    TQHBoxLayout *Layout;
    KIntSpinBox *SpinBox;
    TQLineEdit *EditBox;
    KPushButton *okButton;
    KPushButton *cancelButton;
};
#endif
