/*
 * findnic.h
 *
 * Copyright (c) 2001 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef FINDNIC_H
#define FINDNIC_H

#include <tqptrlist.h>
#include <tqstring.h>

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

struct MyNIC
{
   TQString name;
   TQString addr;
   TQString netmask;
   TQString state;
   TQString type;
};

struct LisaConfigInfo
{
   LisaConfigInfo();
   void clear();
   TQString pingAddresses;
   TQString broadcastNetwork;
   TQString allowedAddresses;
   int secondWait;
   bool secondScan;
   int firstWait;
   int maxPingsAtOnce;
   int updatePeriod;
   bool useNmblookup;
   bool unnamedHosts;
};


typedef TQPtrList<MyNIC> NICList;

//some plain C-like helper functions

///Return a list with all NIC, which are up and broadcast-able
NICList* findNICs();
///Enter some settings into lci which might be appropriate for nic
void suggestSettingsForNic(MyNIC* nic, LisaConfigInfo& lci);

void suggestSettingsForAddress(const TQString& addrMask, LisaConfigInfo& lci);

#endif

