###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for ALSA #####

if( BUILD_ALSA_PLUGIN )
  find_package( ALSA )
  if( NOT ALSA_FOUND )
    tde_message_fatal( "alsa support is requested, but was not found on your system" )
  endif( NOT ALSA_FOUND )
endif( BUILD_ALSA_PLUGIN )


###### check for LAME #####

if( WITH_LAME )
  check_include_file( lame/lame.h HAVE_LAME_H )
  if( NOT HAVE_LAME_H )
    tde_message_fatal( "lame is requested, but not found on your system" )
  endif( )
  check_library_exists( mp3lame lame_init "" HAVE_LAME )
  if( NOT HAVE_LAME )
    tde_message_fatal( "mp3lame is requested, but not found on your system" )
  endif( )
  set( HAVE_LAME 1 )
  set( LAME_LIBRARIES mp3lame CACHE INTERNAL "" FORCE )
endif( WITH_LAME )


##### check for LIRC #####

if( BUILD_LIRC_PLUGIN )
  pkg_search_module( LIRC lirc )

  if( NOT LIRC_FOUND )
    check_library_exists( lirc_client lirc_init "" HAVE_LIRC )
    if( HAVE_LIRC )
      check_include_file( lirc/lirc_client.h HAVE_LIRC_CLIENT_H )
      if( HAVE_LIRC_CLIENT_H )
        set( LIRC_FOUND 1 )
        set( LIRC_LIBRARIES "lirc_client" )
      endif()
    endif()
  endif( NOT LIRC_FOUND )

  if( NOT LIRC_FOUND )
    tde_message_fatal( "lirc support is requested, but was not found on your system" )
  endif( NOT LIRC_FOUND )
endif( BUILD_LIRC_PLUGIN )


##### check for OGG/Vorbis #####

if( WITH_OGG )
  pkg_search_module( VORBIS     vorbis     )
  pkg_search_module( VORBISFILE vorbisfile )
  pkg_search_module( VORBISENC  vorbisenc  )
  pkg_search_module( OGG        ogg        )
  if( NOT VORBIS_FOUND )
    tde_message_fatal( "vorbis is requested, but was not found on your system" )
  elseif( NOT VORBISFILE_FOUND OR NOT VORBISENC_FOUND OR NOT OGG_FOUND )
    tde_message_fatal( "vorbis is requested, but some of it's essential parts wasn't found on your system" )
  endif( )
  set( HAVE_OGG 1 )
endif( WITH_OGG )


##### check for sndfile #####

pkg_search_module( SNDFILE sndfile )
if( NOT SNDFILE_FOUND )
  tde_message_fatal( "sndfile is required, but was not found on your system" )
endif( )


##### Check for videodev #####

check_include_file( "linux/videodev2.h" HAVE_VIDEODEV2_H )
if( HAVE_VIDEODEV2_H )
  set( HAVE_V4L2 1 )
endif( )
