/***************************************************************************
                          displaycfg.cpp  -  description
                             -------------------
    begin                : Fr Aug 15 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "displaycfg.h"
#include <kcolorbutton.h>
#include <kcolordialog.h>
#include <tdefontdialog.h>

#include <tqlayout.h>
#include <tdelocale.h>
#include <tqlabel.h>
#include <tqbuttongroup.h>

DisplayConfiguration::DisplayConfiguration(TQWidget *parent)
    : TQWidget (parent),
      m_dirty(true),
      m_ignore_gui_updates(false)
{
    TQGroupBox *bg = new TQGroupBox(i18n("Display Colors"), this);
    bg->setColumnLayout(0, TQt::Vertical );
    bg->layout()->setSpacing( 8 );
    bg->layout()->setMargin( 12 );
    TQGridLayout *gl = new TQGridLayout (bg->layout());

    m_btnActive   = new KColorButton(queryDisplayActiveColor(), bg);
    m_btnInactive = new KColorButton(queryDisplayInactiveColor(), bg);
    m_btnBkgnd    = new KColorButton(queryDisplayBkgndColor(), bg);

    connect(m_btnActive,   TQ_SIGNAL(changed(const TQColor &)), this, TQ_SLOT(slotSetDirty()));
    connect(m_btnInactive, TQ_SIGNAL(changed(const TQColor &)), this, TQ_SLOT(slotSetDirty()));
    connect(m_btnBkgnd,    TQ_SIGNAL(changed(const TQColor &)), this, TQ_SLOT(slotSetDirty()));

    TQLabel *l1  = new TQLabel(i18n("Active Text"), bg);
    TQLabel *l2  = new TQLabel(i18n("Inactive Text"), bg);
    TQLabel *l3  = new TQLabel(i18n("Background Color"), bg);

    l1->setAlignment(TQLabel::AlignCenter);
    l2->setAlignment(TQLabel::AlignCenter);
    l3->setAlignment(TQLabel::AlignCenter);

    l1->setSizePolicy(TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed));
    l2->setSizePolicy(TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed));
    l3->setSizePolicy(TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed));
    m_btnActive  ->setSizePolicy(TQSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding));
    m_btnInactive->setSizePolicy(TQSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding));
    m_btnBkgnd   ->setSizePolicy(TQSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding));

    m_btnActive  ->setMinimumSize(TQSize(40, 40));
    m_btnInactive->setMinimumSize(TQSize(40, 40));
    m_btnBkgnd   ->setMinimumSize(TQSize(40, 40));

    gl->addWidget (l1,                   0, 0, TQt::AlignCenter);
    gl->addWidget (l2,                   0, 1, TQt::AlignCenter);
    gl->addWidget (l3,                   0, 2, TQt::AlignCenter);
    gl->addWidget (m_btnActive,          1, 0);
    gl->addWidget (m_btnInactive,        1, 1);
    gl->addWidget (m_btnBkgnd,           1, 2);

    m_fontChooser = new TDEFontChooser(this, NULL, false, TQStringList(), true, 4);
    m_fontChooser->setFont(queryDisplayFont());
    m_fontChooser->setSizePolicy(TQSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding));

    TQVBoxLayout  *l = new TQVBoxLayout(this, 10);
    l->addWidget(bg);
    l->addWidget(m_fontChooser);

    connect(m_btnActive,   TQ_SIGNAL(changed(const TQColor &)),     this, TQ_SLOT(slotSetDirty()));
    connect(m_btnInactive, TQ_SIGNAL(changed(const TQColor &)),     this, TQ_SLOT(slotSetDirty()));
    connect(m_btnBkgnd,    TQ_SIGNAL(changed(const TQColor &)),     this, TQ_SLOT(slotSetDirty()));
    connect(m_fontChooser, TQ_SIGNAL(fontSelected(const TQFont &)), this, TQ_SLOT(slotSetDirty()));

}


DisplayConfiguration::~DisplayConfiguration()
{
}


bool DisplayConfiguration::noticeDisplayColorsChanged(const TQColor &activeColor, const TQColor &inactiveColor, const TQColor &bkgnd)
{
    m_ignore_gui_updates = true;
    m_btnActive->setColor(activeColor);
    m_btnInactive->setColor(inactiveColor);
    m_btnBkgnd->setColor(bkgnd);
    m_ignore_gui_updates = false;
    return true;
}


bool DisplayConfiguration::noticeDisplayFontChanged(const TQFont &f)
{
    m_ignore_gui_updates = true;
    m_fontChooser->setFont(f);
    m_ignore_gui_updates = false;
    return true;
}


void DisplayConfiguration::slotOK()
{
    if (m_dirty) {
        sendDisplayColors(m_btnActive->color(), m_btnInactive->color(), m_btnBkgnd->color());
        sendDisplayFont(m_fontChooser->font());
        m_dirty = false;
    }
}

void DisplayConfiguration::slotCancel()
{
    if (m_dirty) {
        m_ignore_gui_updates = true;
        m_btnActive  ->setColor(queryDisplayActiveColor());
        m_btnInactive->setColor(queryDisplayInactiveColor());
        m_btnBkgnd   ->setColor(queryDisplayBkgndColor());
        m_fontChooser->setFont(queryDisplayFont());
        m_dirty = false;
        m_ignore_gui_updates = false;
    }
}

void DisplayConfiguration::slotSetDirty()
{
    if (!m_dirty && !m_ignore_gui_updates) {
        m_dirty = true;
        emit sigDirty();
    }
}


#include "displaycfg.moc"
