/***************************************************************************
                                filespage.cpp
                                -------------------
        begin                   : Sun Apr 18 2004
        copyright               : (C) 2004 Otto Bruggeman
        email                   : otto.bruggeman@home.nl

****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#include <tqlayout.h>
#include <tqgroupbox.h>

#include <tdeapplication.h>
#include <kcharsets.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <kdialog.h>
#include <tdelocale.h>
#include <kurlcombobox.h>
#include <kurlrequester.h>

#include "filessettings.h"
#include "filespage.h"

FilesPage::FilesPage( TQWidget* parent ) : PageBase( parent ), m_URLChanged( false )
{
	TQWidget* page = new TQWidget( this );
	TQVBoxLayout* layout = new TQVBoxLayout( page );
	layout->setSpacing( KDialog::spacingHint() );
	layout->setMargin( KDialog::marginHint() );

	m_firstGB = new TQGroupBox( 1, TQt::Vertical, "You have to set this. :)", page );
	m_firstURLComboBox = new KURLComboBox( KURLComboBox::Both, true, m_firstGB, "SourceURLComboBox" );
	m_firstURLRequester = new KURLRequester( m_firstURLComboBox, m_firstGB );
	m_firstURLRequester->setFocus();

	m_secondGB = new TQGroupBox( 1, TQt::Vertical, "This too!", page );
	m_secondURLComboBox = new KURLComboBox( KURLComboBox::Both, true, m_secondGB, "DestURLComboBox" );
	m_secondURLRequester = new KURLRequester( m_secondURLComboBox, m_secondGB );

	connect( m_firstURLRequester, TQ_SIGNAL( urlSelected( const TQString & ) ), TQ_SLOT( setSecondURL( const TQString & ) ) );
	connect( m_secondURLRequester, TQ_SIGNAL( urlSelected( const TQString & ) ), TQ_SLOT( setFirstURL( const TQString & ) ) );

	m_thirdGB = new TQGroupBox( 1, TQt::Vertical, i18n( "Encoding" ), page );
	m_encodingComboBox = new TQComboBox( false, m_thirdGB, "encoding_combobox" );
	m_encodingComboBox->insertStringList( TDEGlobal::charsets()->availableEncodingNames() );

	layout->addWidget( m_firstGB );
	layout->addWidget( m_secondGB );
	layout->addWidget( m_thirdGB );

	layout->addStretch( 1 );
	page->setMinimumSize( sizeHintForWidget( page ) );

	addTab( page, i18n( "&Files" ) );
}

FilesPage::~FilesPage()
{
	m_settings = 0;
}

KURLRequester* FilesPage::firstURLRequester() const
{
	return m_firstURLRequester;
}

KURLRequester* FilesPage::secondURLRequester() const
{
	return m_secondURLRequester;
}

TQString FilesPage::encoding() const
{
	return m_encodingComboBox->currentText();
}

void FilesPage::setFirstGroupBoxTitle( const TQString& title )
{
	m_firstGB->setTitle( title );
}

void FilesPage::setSecondGroupBoxTitle( const TQString& title )
{
	m_secondGB->setTitle( title );
}

void FilesPage::setURLsInComboBoxes()
{
//	kdDebug() << "first : " << m_firstURLComboBox->currentText() << endl;
//	kdDebug() << "second: " << m_secondURLComboBox->currentText() << endl;
	m_firstURLComboBox->setURL( KURL( m_firstURLComboBox->currentText() ) );
	m_secondURLComboBox->setURL( KURL( m_secondURLComboBox->currentText() ) );
}


void FilesPage::setFirstURLRequesterMode( unsigned int mode )
{
	m_firstURLRequester->setMode( mode );
}

void FilesPage::setSecondURLRequesterMode( unsigned int mode )
{
	m_secondURLRequester->setMode( mode );
}

void FilesPage::setSettings( FilesSettings* settings )
{
	m_settings = settings;

	m_firstURLComboBox->setURLs( m_settings->m_recentSources );
	m_firstURLComboBox->setURL( KURL( m_settings->m_lastChosenSourceURL ) );
	m_secondURLComboBox->setURLs( m_settings->m_recentDestinations );
	m_secondURLComboBox->setURL( KURL( m_settings->m_lastChosenDestinationURL ) );
	m_encodingComboBox->setCurrentText( m_settings->m_encoding );
}

void FilesPage::restore()
{
	// this shouldn't do a thing...
}

void FilesPage::apply()
{
	m_settings->m_recentSources            = m_firstURLComboBox->urls();
	m_settings->m_lastChosenSourceURL      = m_firstURLComboBox->currentText();
	m_settings->m_recentDestinations       = m_secondURLComboBox->urls();
	m_settings->m_lastChosenDestinationURL = m_secondURLComboBox->currentText();
	m_settings->m_encoding                 = m_encodingComboBox->currentText();
}

void FilesPage::setDefaults()
{
	m_firstURLComboBox->setURLs( "" );
	m_firstURLComboBox->setURL( KURL( "" ) );
	m_secondURLComboBox->setURLs( "" );
	m_secondURLComboBox->setURL( KURL( "" ) );
	m_encodingComboBox->setCurrentText( "Default" );
}

void FilesPage::setFirstURL( const TQString &url )
{
	TQString _url = url;
	if ( !m_URLChanged )
	{
		m_firstURLRequester->setURL( _url.remove( url.section( '/', -1 ) ) );
		m_URLChanged = true;
	}
}

void FilesPage::setSecondURL( const TQString &url )
{
	TQString _url = url;
	if ( !m_URLChanged )
	{
		m_secondURLRequester->setURL( _url.remove( url.section( '/', -1 ) ) );
		m_URLChanged = true;
	}
}

#include "filespage.moc"
