/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef _FILLCACHE_THREAD_H
#define _FILLCACHE_THREAD_H

#include "client.h"
#include "revision.h"
#include "status.h"
#include "ccontextlistener.h"
#include "eventnumbers.h"
#include "frontendtypes.h"

#include <tqthread.h>
#include <tqevent.h>
#include <tqmutex.h>

class TQObject;

class FillCacheThread:public TQThread
{
public:
    FillCacheThread(TQObject*,const TQString&reposRoot);
    virtual ~FillCacheThread();
    virtual void run();
    virtual void cancelMe();

    const TQString&reposRoot()const;

protected:
    TQMutex mutex;
    svn::Client* m_Svnclient;
    svn::ContextP m_CurrentContext;
    svn::smart_pointer<ThreadContextListener> m_SvnContextListener;
    TQObject*m_Parent;
    TQString m_what;
};

#endif
