/***************************************************************************
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "shellfilterdlg.h"

#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <kbuttonbox.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeprocess.h>
#include <kstdguiitem.h>
#include <tdeversion.h>

#include "kdevplugin.h"
#include "domutil.h"
#include "filterpart.h"


ShellFilterDialog::ShellFilterDialog()
    : TQDialog(0, "shell filter dialog", true)
{
    TQVBoxLayout *layout = new TQVBoxLayout(this, 10, 4);

    combo = new TQComboBox(true, this);
    combo->setDuplicatesEnabled(false);
    layout->addWidget(combo);

    KButtonBox *buttonbox = new KButtonBox(this);
    start_button = buttonbox->addButton(i18n("&Start"));
    start_button->setDefault(true);
    cancel_button = buttonbox->addButton(KStdGuiItem::cancel());
    buttonbox->layout();
    layout->addWidget(buttonbox);

    connect( start_button, TQ_SIGNAL(clicked()),
             this, TQ_SLOT(slotStartClicked()) );
    connect( cancel_button, TQ_SIGNAL(clicked()),
             this, TQ_SLOT(reject()) );

    m_proc = 0;

    TDEConfig *config = FilterFactory::instance()->config();
    config->setGroup("General");
    combo->insertStringList(config->readListEntry("filteritems"));
}


ShellFilterDialog::~ShellFilterDialog()
{
    kdDebug(9029) << "~ShellFilterDialog" << endl;
    delete m_proc;

    // TQComboBox API is a bit incomplete :-(
    TQStringList list;
    for (int i=0; i < combo->count(); ++i)
        list << combo->text(i);

    TDEConfig *config = FilterFactory::instance()->config();
    config->setGroup("General");
    config->writeEntry("filteritems", list);
}


void ShellFilterDialog::slotStartClicked()
{
    start_button->setEnabled(false);
    m_outstr = TQCString();

    delete m_proc;
    m_proc = new KShellProcess("/bin/sh");
    (*m_proc) << combo->currentText();
    connect( m_proc, TQ_SIGNAL(receivedStdout(TDEProcess*, char *, int)),
             this, TQ_SLOT(slotReceivedStdout(TDEProcess*, char *, int)) );
    connect( m_proc, TQ_SIGNAL(wroteStdin(TDEProcess*)),
             this, TQ_SLOT(slotWroteStdin(TDEProcess*)) );
    connect( m_proc, TQ_SIGNAL(processExited(TDEProcess*)),
             this, TQ_SLOT(slotProcessExited(TDEProcess*)) );
    m_proc->start(TDEProcess::NotifyOnExit, TDEProcess::All);
    m_proc->writeStdin(m_instr, m_instr.length());
}


int ShellFilterDialog::exec()
{
    start_button->setEnabled(true);
    return TQDialog::exec();
}


void ShellFilterDialog::slotReceivedStdout(TDEProcess *, char *text, int len)
{
    m_outstr += TQString::fromLocal8Bit(text, len+1);
    kdDebug(9029) << "outstr " << m_outstr << endl;
}


void ShellFilterDialog::slotWroteStdin(TDEProcess *)
{
    m_proc->closeStdin();
    kdDebug(9029) << "close stdin " << m_outstr << endl;
}


void ShellFilterDialog::slotProcessExited(TDEProcess *)
{
    kdDebug(9029) << "process exit " << m_proc->normalExit() << endl;
    if (m_proc->normalExit()) {
        accept();
    } else {
        KMessageBox::error(this, i18n("Process exited with status %1")
                           .arg(m_proc->exitStatus()));
        reject();
    }
}

#include "shellfilterdlg.moc"
