/***************************************************************************
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TEXTTOOLSPART_H_
#define _TEXTTOOLSPART_H_

#include <tqguardedptr.h>
#include <tdeparts/part.h>
#include "kdevplugin.h"

class TextToolsWidget;


class TextToolsPart : public KDevPlugin
{
    TQ_OBJECT
  

public:
    TextToolsPart( TQObject *parent, const char *name, const TQStringList & );
    ~TextToolsPart();

private slots:
    void activePartChanged(KParts::Part *part);

private:
    void createWidget();
    
    TQGuardedPtr<TextToolsWidget> m_widget;
};

#endif
