#include <config.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tdemainwindow.h>
#include <tdestandarddirs.h>
#include <kdebug.h>
#include <dcopclient.h>

#include <tqfileinfo.h>

#include "splashscreen.h"
#include "toplevel.h"
#include "plugincontroller.h"
#include "partcontroller.h"
#include "core.h"
#include "projectmanager.h"

#include "kdevideextension.h"

static TDECmdLineOptions options[] =
{
    { "profile <profile>",	I18N_NOOP("Profile to load"), 0 },
    { "+file(s)",		I18N_NOOP("Files to load"), 0 },
    { 0,0,0 }
};

int main(int argc, char *argv[])
{
  static const char description[] = I18N_NOOP("The TDevelop Integrated Development Environment");
  TDEAboutData aboutData("tdevelop", I18N_NOOP("TDevelop"),
                       VERSION, description, TDEAboutData::License_GPL,
                       I18N_NOOP("(c) 1999-2007, The KDevelop developers"), "", "http://www.kdevelop.org");
  aboutData.addAuthor("Alexander Dymo", I18N_NOOP("Release coordinator, Overall improvements, Pascal support, C++ support, New File and Documentation parts"), "adymo@kdevelop.org");
  aboutData.addAuthor("Amilcar do Carmo Lucas", I18N_NOOP("Release coordinator, API documentation, Doxygen and autoproject patches"), "amilcar@ida.ing.tu-bs.de");
  aboutData.addAuthor("David Nolden", I18N_NOOP("Advanced C++ code completion, C++ support, overall improvements"), "david.nolden.kdevelop@art-master.de");
  aboutData.addAuthor("Bernd Gehrmann", I18N_NOOP("Initial idea, basic architecture, much initial source code"), "bernd@kdevelop.org");
  aboutData.addAuthor("Caleb Tennis", I18N_NOOP("KTabBar, bugfixes"), "caleb@aei-tech.com");
  aboutData.addAuthor("Richard Dale", I18N_NOOP("Java & Objective C support"), "Richard_Dale@tipitina.demon.co.uk");
  aboutData.addAuthor("John Birch", I18N_NOOP("Debugger frontend"), "jbb@kdevelop.org");
  aboutData.addAuthor("Vladimir Prus", I18N_NOOP("Debugger frontend"), "ghost@cs.msu.su");
  aboutData.addAuthor("Sandy Meier", I18N_NOOP("PHP support, context menu stuff"), "smeier@kdevelop.org");
  aboutData.addAuthor("Kurt Granroth", I18N_NOOP("TDE application templates"), "kurth@granroth.org");
  aboutData.addAuthor("Ian Reinhart Geiser", I18N_NOOP("Dist part, bash support, application templates"), "geiseri@yahoo.com");
  aboutData.addAuthor("Matthias Hoelzer-Kluepfel", I18N_NOOP("Several components, htdig indexing"), "hoelzer@kde.org");
  aboutData.addAuthor("Victor Roeder", I18N_NOOP("Help with Automake manager and persistent class store"), "victor_roeder@gmx.de");
  aboutData.addAuthor("Megan Webb", I18N_NOOP("Automake manager patches, Astyle plugin update, plugin patches and improvements"),"tdeveloper.megan@gmail.com");
  aboutData.addAuthor("Harald Fernengel", I18N_NOOP("Ported to TQt 3, patches, valgrind, diff and perforce support"), "harry@kdevelop.org");
  aboutData.addAuthor("Roberto Raggi", I18N_NOOP("TQEditor component, code completion, Abbrev component, C++ support, Java support"), "roberto@kdevelop.org");
  aboutData.addAuthor("Simon Hausmann", I18N_NOOP("Help with KParts infrastructure"), "hausmann@kde.org");
  aboutData.addAuthor("Oliver Kellogg", I18N_NOOP("Ada support"), "okellogg@users.sourceforge.net");
  aboutData.addAuthor("Andreas Pakulat", I18N_NOOP("TQMake projectmanager, TQt4 Support"), "apaku@gmx.de");
  aboutData.addAuthor("Jakob Simon-Gaarde", I18N_NOOP("TQMake projectmanager"), "jsgaarde@tdcspace.dk");
  aboutData.addAuthor("F@lk Brettschneider", I18N_NOOP("MDI modes, TQEditor, bugfixes"), "falkbr@kdevelop.org");
  aboutData.addAuthor("Mario Scalas", I18N_NOOP("PartExplorer, redesign of CvsPart, patches, bugs(fixes)"), "mario.scalas@libero.it");
  aboutData.addAuthor("Jens Dagerbo", I18N_NOOP("Replace, Bookmarks, FileList and CTags2 plugins. Overall improvements and patches"), "jens.dagerbo@swipnet.se");
  aboutData.addAuthor("Julian Rockey", I18N_NOOP("Filecreate part and other bits and patches"), "linux@jrockey.com");
  aboutData.addCredit("Ajay Guleria", I18N_NOOP("ClearCase support"), "ajay_guleria@yahoo.com");
  aboutData.addCredit("Marek Janukowicz", I18N_NOOP("Ruby support"), "child@t17.ds.pwr.wroc.pl");

  aboutData.addCredit("The KWrite authors", I18N_NOOP("Kate editor component"), "kwrite-devel@kde.org");
  aboutData.addCredit("The TDEHTML authors", I18N_NOOP("HTML documentation component"), "kwrite-devel@kde.org");
  aboutData.addCredit("Robert Moniot", I18N_NOOP("Fortran documentation"), "moniot@fordham.edu");
  aboutData.addCredit("Ka-Ping Yee", I18N_NOOP("Python documentation utility"), "ping@lfw.org");
  aboutData.addCredit("Dimitri van Heesch", I18N_NOOP("Doxygen wizard"), "dimitri@stack.nl");
  aboutData.addCredit("Hugo Varotto", I18N_NOOP("Fileselector component"), "hugo@varotto-usa.com");
  aboutData.addCredit("Matt Newell", I18N_NOOP("Fileselector component"), "newellm@proaxis.com");
  aboutData.addCredit("Trolltech AS", I18N_NOOP("Designer code"), "info@trolltech.com");
  aboutData.addCredit("Daniel Engelschalt", I18N_NOOP("C++ code completion, persistent class store"), "daniel.engelschalt@gmx.net");
  aboutData.addCredit("Stephane ANCELOT", I18N_NOOP("Patches"), "sancelot@free.fr");
  aboutData.addCredit("Jens Zurheide", I18N_NOOP("Patches"), "jens.zurheide@gmx.de");
  aboutData.addCredit("Luc Willems", I18N_NOOP("Help with Perl support"), "Willems.luc@pandora.be");
  aboutData.addCredit("Marcel Turino", I18N_NOOP("Documentation index view"), "M.Turino@gmx.de");
  aboutData.addCredit("Yann Hodique", I18N_NOOP("Patches"), "Yann.Hodique@lifl.fr");
  aboutData.addCredit("Tobias Gl\303\244\303\237er" , I18N_NOOP("Documentation Finder,  qmake projectmanager patches, usability improvements, bugfixes ... "), "tobi.web@gmx.de");
  aboutData.addCredit("Andreas Koepfle" , I18N_NOOP("TQMake project manager patches"), "koepfle@ti.uni-mannheim.de");
  aboutData.addCredit("Sascha Cunz" , I18N_NOOP("Cleanup and bugfixes for qEditor, AutoMake and much other stuff"), "sascha@kdevelop.org");
  aboutData.addCredit("Robert Gruber" , I18N_NOOP("SnippetPart, debugger and usability patches"), "rgruber@users.sourceforge.net");
  aboutData.addCredit("Zoran Karavla", I18N_NOOP("Artwork for the Ruby language"), "webmaster@the-error.net", "http://the-error.net");

  TDECmdLineArgs::init(argc, argv, &aboutData);
  TDECmdLineArgs::addCmdLineOptions( options );
  TDECmdLineArgs* args = TDECmdLineArgs::parsedArgs();

  TDEApplication app;

  KDevIDEExtension::init();

  KDevSplashScreen *splash = 0;
  TQString splashFile = locate("appdata", "pics/tdevelop-splash.png");
  if (!splashFile.isEmpty())
  {
    TQPixmap pm;
    pm.load(splashFile);
    splash = new KDevSplashScreen( pm );
  }

  app.processEvents();

  if (splash) splash->message( i18n( "Loading Settings" ) );
  TopLevel::getInstance()->loadSettings();

  TQObject::connect(PluginController::getInstance(), TQ_SIGNAL(loadingPlugin(const TQString &)),
    splash, TQ_SLOT(message(const TQString &)));
  if (splash) splash->show();

  PluginController::getInstance()->loadInitialPlugins();

  Core::getInstance()->doEmitCoreInitialized();

  if (splash) splash->message( i18n( "Starting GUI" ) );
  TopLevel::getInstance()->main()->show();

  if (splash) delete splash;

  for( int i=0; i<args->count(); ++i ){
      kdDebug(9000) << "------> arg " << args->arg(i) << endl;
  }

  bool openProject = false;
  if( args->count() == 0 ){
      ProjectManager::getInstance()->loadDefaultProject();
      openProject = true;
  } else if( args->count() > 0 ){
      KURL url = args->url( 0 );
      TQString ext = TQFileInfo( url.fileName() ).extension();
      if( ext == "kdevelop" ){
	  ProjectManager::getInstance()->loadProject( url );
	  openProject = true;
      }
  }

  if( !openProject ){
      for( int a=0; a<args->count(); ++a ){
	  PartController::getInstance()->editDocument( KURL(args->url(a)) );
      }
  }

  tdeApp->dcopClient()->registerAs("tdevelop");

  int ret = app.exec();

  ProjectManager::getInstance()->closeProject( true ); // exiting
  delete ProjectManager::getInstance();

  delete PluginController::getInstance();
  if (TopLevel::mainWindowValid())
      delete TopLevel::getInstance();

  return ret;
}
