/*
 *  Copyright (C) 2007 Dukju Ahn (dukjuahn@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef SVNLOGVIEWWIDGET_H
#define SVNLOGVIEWWIDGET_H

#include "subversion_widget.h"
#include "svn_logviewoptiondlgbase.h"
// #include "subversion_part.h"
#include <tqvaluelist.h>
#include <tqlistview.h>
class subversionPart;
// class TQWidget;
#include <tqwidget.h>
class KTextEdit;
class TQSplitter;
class TQGridLayout;
class SvnLogViewItem;

class SvnLogHolder{
	public:
		SvnLogHolder(){};
		~SvnLogHolder(){};
		TQString author;
		TQString date;
		TQString logMsg;
		TQString pathList;
		TQString rev;
};

class SvnLogViewWidget : public /*SvnLogViewWidgetBase*/ TQWidget {
	TQ_OBJECT
  
public:
	SvnLogViewWidget(subversionPart *part, TQWidget *parent);
	virtual ~SvnLogViewWidget();
	void setLogResult( TQValueList<SvnLogHolder> *loglist );
	void setRequestedUrl( TQString url );

protected slots:
	void slotClicked( TQListViewItem* item );
    void contextMenuRequested( TQListViewItem *item, const TQPoint & pos, int col );
    void blameThis();
    void diffToPrevious();
    
private:
	TQString m_reqUrl;
	subversionPart *m_part;
    SvnLogViewItem* m_ctxLogItem;

    TQSplitter* splitter1;
    TQListView* listView1;
    KTextEdit* textEdit1;
    TQGridLayout* m_layout;
    
};

class SvnLogViewOptionDlg : public SvnLogViewOptionDlgBase {
	TQ_OBJECT
  
public:
	SvnLogViewOptionDlg(TQWidget *parent=0, const char* name=0, bool modal=true, WFlags f=0);
	~SvnLogViewOptionDlg();
	int revstart();
	TQString revKindStart();
	int revend();
	TQString revKindEnd();
	bool strictNode();
public slots:
	void reinstallRevisionSpecifiers();
	void setStartRevnumRadio();
	void setStartRevkindRadio();
	void setEndRevnumRadio();
	void setEndRevkindRadio();
};

#endif

