/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef LISTVIEWEDITORIMPL_H
#define LISTVIEWEDITORIMPL_H

#include "listvieweditor.h"

#include <tqmap.h>
#include <tqpixmap.h>
#include <tqvaluelist.h>

class FormWindow;

class ListViewEditor : public ListViewEditorBase
{
    TQ_OBJECT
  

public:
    ListViewEditor( TQWidget *parent, TQListView *lv, FormWindow *fw );

protected slots:
    void applyClicked();
    void columnClickable(bool);
    void columnDownClicked();
    void columnPixmapChosen();
    void columnPixmapDeleted();
    void columnResizable(bool);
    void columnTextChanged(const TQString &);
    void columnUpClicked();
    void currentColumnChanged(TQListBoxItem*);
    void currentItemChanged(TQListViewItem*);
    void deleteColumnClicked();
    void itemColChanged(int);
    void itemDeleteClicked();
    void itemDownClicked();
    void itemNewClicked();
    void itemNewSubClicked();
    void itemPixmapChoosen();
    void itemPixmapDeleted();
    void itemTextChanged(const TQString &);
    void itemUpClicked();
    void itemLeftClicked();
    void itemRightClicked();
    void newColumnClicked();
    void okClicked();
    void initTabPage( const TQString &page );

private:
    struct Column
    {
	TQListBoxItem *item;
	TQString text;
	TQPixmap pixmap;
	bool clickable, resizable;
    };

private:
    void setupColumns();
    void setupItems();
    Column *findColumn( TQListBoxItem *i );
    void transferItems( TQListView *from, TQListView *to );
    void displayItem( TQListViewItem *i, int col );

private:
    TQListView *listview;
    TQValueList<Column> columns;
    int numColumns;
    FormWindow *formwindow;

};


#endif
