/***************************************************************************
                          quantaplugineditor.h  -  description
                             -------------------
    begin                : Fri Sep 20 2002
    copyright            : (C) 2002 by Marc Britton <consume@optushome.com.au>
                           (C) 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QUANTAPLUGINEDITOR_H
#define QUANTAPLUGINEDITOR_H

/* KDE INCLUDES */
#include <kdialogbase.h>

/* QT INCLUDES */
#include <tqdict.h>
#include <tqlistview.h>

/* OTHER INCLUDES */
#include "quantaplugin.h"
#include "plugineditor.h"

/**Editor for the plugins that manages configuration
  *@author Marc Britton
  */

/* FORWARD DECLARATIONS */
class TQWidget;
class TQListView;
class KDialogBase;
class PluginEditor;

class QuantaPluginEditor : public KDialogBase
{
  TQ_OBJECT
  

public:
  QuantaPluginEditor(TQWidget *, const char *);
  ~QuantaPluginEditor();
  TQDict<QuantaPlugin> plugins();
  /** No descriptions */
  TQStringList searchPathList();
  /** No descriptions */
  void setSearchPaths(const TQStringList& paths);

signals:
  void pluginsChanged();

public slots:
  void setPlugins(TQDict<QuantaPlugin>);
  void addSearchPath();
  void addPlugin();
  void removePlugin();
  void configurePlugin();
  void configurePlugin(TQListViewItem*, const TQPoint&, int);
  void refreshPlugins();

protected:
  TQDict<QuantaPlugin> m_plugins;
  PluginEditor *m_pluginEditorWidget;
};

class PluginEditorItem : public TQListViewItem
{
public:
  PluginEditorItem(TQListView *);
  virtual void paintCell(TQPainter *, const TQColorGroup &, int, int, int);
};

#endif
