/***************************************************************************
*   Copyright (C) 2006 - 2008 Robert Hogan                                *
*   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/


#ifndef _DNDLISTVIEW_H_
#define _DNDLISTVIEW_H_

#include <tqlistview.h>
#include <tqdragobject.h>

class TQDragEnterEvent;
class TQDragDropEvent;


class DndListView : public TQListView
{
TQ_OBJECT

public:
    DndListView( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );
    TQPoint m_mousepos;
    TQPoint getMousePos();
    bool recentDropEvent() { return m_recentDrop; };
    void contentsMouseReleaseEvent( TQMouseEvent *e );

protected:
    void contentsDragEnterEvent( TQDragEnterEvent *e );
    void contentsDragMoveEvent( TQDragMoveEvent *e );
    void contentsDragLeaveEvent( TQDragLeaveEvent *e );
    void contentsDropEvent( TQDropEvent *e );
    void contentsMouseMoveEvent( TQMouseEvent *e );
    void contentsMousePressEvent( TQMouseEvent *e );
    void mouseReleaseEvent( TQMouseEvent *e );
    void timerEvent( TQTimerEvent * );
    void viewportPaintEvent( TQPaintEvent *e );


private:
    TQListViewItem *oldCurrent;
    TQListViewItem *dropItem;
/*    TQTimer* autoopen_timer;*/
    TQPoint presspos;
    bool mousePressed;
    int dropTimer;
    bool m_recentDrop;
signals:

    void attach(const TQString &, const TQString &);
    void extendCircuit(const TQString &, const TQString &, bool);
    void createCircuit(const TQString &, bool);
    void itemAdded(TQListViewItem *);





/*    void dragEnterEvent( TQDragEnterEvent *evt );
    void dropEvent( TQDropEvent *evt );
    void contentsMousePressEvent( TQMouseEvent *evt );
    void contentsMouseMoveEvent( TQMouseEvent * );*/
//     TQDragObject *dragObject();
// private:
//     bool dragging;


};
#endif // _TORKVIEW_H_
