/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

// TDE
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>

// Portal
#include "portal_daemon.h"


static const char description[] = I18N_NOOP("TDE XDG desktop portal");
static TDECmdLineOptions options[] = {};

int main(int argc, char **argv)
{
    TDEAboutData about("xdg-desktop-portal-tde", "xdg-desktop-portal-tde", "1.0",
                       description, TDEAboutData::License_LGPL,
                       I18N_NOOP("Copyright © 2024 Mavridis Philippe"));

    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);
    TDEUniqueApplication::addCmdLineOptions();

    if (!TDEUniqueApplication::start())
        return 0;

    PortalDaemon app;
    app.disableSessionManagement();
    return app.exec();
}

// kate: replace-tabs true; tab-width 4; indent-width 4;