/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CBTCONFIG_H
#define CBTCONFIG_H

#include "backend/cswordbackend.h"
#include "backend/clanguagemgr.h"

//TQt includes
#include <tqstring.h>
#include <tqfont.h>
#include <tqvaluelist.h>
#include <tqmap.h>

//Forward declarations
class TDEAccel;
class TDEActionCollection;
class TDEConfig;

/**
 * This class is the interface to the config object of BibleTime
 * @author The BibleTime team
 */
class CBTConfig {
public:
	typedef TQMap<TQString, TQString> StringMap;

	enum strings {
		bibletimeVersion,
		language,
		displayStyle,
		bookshelfCurrentItem
	};
	enum modules {
		standardBible = 0, //just to make sure, default is IMHO 0, so that's redundant here
		standardCommentary,
		standardLexicon,
		standardDailyDevotional,
		standardHebrewStrongsLexicon,
		standardGreekStrongsLexicon,
		standardHebrewMorphLexicon,
		standardGreekMorphLexicon,
		lastModuleType = standardGreekMorphLexicon
	};
	enum bools {
		firstSearchDialog,
		readOldBookmarks,

		toolbar,
		mainIndex,
		infoDisplay,

		autoTileVertical,
		autoTileHorizontal,
		autoCascade,

		lineBreaks,
		verseNumbers,

		tips,
		logo,
		autoDeleteOrphanedIndices,
		crashedLastTime,
		crashedTwoTimes
	};
	enum ints {
		footnotes,
		strongNumbers,
		headings,
		morphTags,
		lemmas,
		hebrewPoints,
		hebrewCantillation,
		greekAccents,
		textualVariants,
		scriptureReferences,
		morphSegmentation,
		bookshelfContentsX,
		bookshelfContentsY,
  		magDelay /* The delay until a mouse move makes the content appear in the mag */
	};
	enum intLists {
		leftPaneSplitterSizes,
		mainSplitterSizes
	};
	enum stringLists {
		searchCompletionTexts,
		searchTexts,
		bookshelfOpenGroups
	};
	enum keys {
		allWindows,
		readWindow,
		writeWindow,
		bookWindow,
		bibleWindow,
		commentaryWindow,
		lexiconWindow,
		application
	};
	enum stringMaps {
		searchScopes
	};
	typedef std::pair<bool, TQFont> FontSettingsPair;
	typedef TQMap<const CLanguageMgr::Language*, CBTConfig::FontSettingsPair> FontCache;

	static const TQString   get
		( const CBTConfig::strings );
	static CSwordModuleInfo* const get
		( const CBTConfig::modules );
	static const bool    get
		( const CBTConfig::bools );
	static const int      get
		( const CBTConfig::ints );
	static const TQValueList<int> get
		( const CBTConfig::intLists );
	static const TQStringList get
		( const CBTConfig::stringLists );
	static const CBTConfig::StringMap get
		( const CBTConfig::stringMaps );

	static const FontSettingsPair get
		( const CLanguageMgr::Language* const );

	static const TQString getDefault( const CBTConfig::strings );
	static const TQString getDefault( const CBTConfig::modules );
	static const bool getDefault( const CBTConfig::bools );
	static const int getDefault( const CBTConfig::ints );
	static const TQValueList<int> getDefault( const CBTConfig::intLists );
	static const TQStringList getDefault( const CBTConfig::stringLists );
	static const CBTConfig::StringMap getDefault( const CBTConfig::stringMaps );
	static const TQFont& getDefault( const CLanguageMgr::Language* const );

	static void set
		( const CBTConfig::strings,  const TQString value );
	static void set
		( const CBTConfig::modules, CSwordModuleInfo* const module );
	static void set
		( const CBTConfig::modules, const TQString& moduleName );
	static void set
		( const CBTConfig::bools,   const bool value );
	static void set
		( const CBTConfig::ints,   const int value );
	static void set
		( const CBTConfig::intLists, const TQValueList<int> value );
	static void set
		( const CBTConfig::stringLists, const TQStringList value);
	static void set
		( const CBTConfig::stringMaps, const CBTConfig::StringMap value);
	static void set
		( const CLanguageMgr::Language* const language, const FontSettingsPair& fontSettings );

	static const CSwordBackend::FilterOptions getFilterOptionDefaults();
	static const CSwordBackend::DisplayOptions getDisplayOptionDefaults();

	static void setupAccelSettings(const CBTConfig::keys type, TDEActionCollection* const actionCollection);
	static void saveAccelSettings(const CBTConfig::keys type, TDEActionCollection* const actionCollection);

	static const TQString getModuleEncryptionKey( const TQString& name );
	static void setModuleEncryptionKey( const TQString& name, const TQString& key );

	/** The config object.
	* @return A config object which is used currently, may be the global config or the session config
	*/
	static TDEConfig* const getConfig();

private:
	static const TQString getKey( const CBTConfig::strings );
	static const TQString getKey( const CBTConfig::modules );
	static const TQString getKey( const CBTConfig::bools );
	static const TQString getKey( const CBTConfig::ints );
	static const TQString getKey( const CBTConfig::intLists );
	static const TQString getKey( const CBTConfig::stringLists );
	static const TQString getKey( const CBTConfig::stringMaps );
	static const TQString getKey( const CLanguageMgr::Language* const );

	//static caches
	static TQFont* m_defaultFont;

	static FontCache* fontConfigMap;
};


#endif
