/***************************************************************************
*   Copyright (C) 2005 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef INGREDIENTPARSERDIALOG_H
#define INGREDIENTPARSERDIALOG_H

#include <kdialogbase.h>

#include "datablocks/ingredientlist.h"
#include "datablocks/unit.h"

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQLabel;
class TQTextEdit;
class TQLineEdit;
class KPushButton;
class TDEListView;
class TQListViewItem;
class TQPushButton;

class IngredientParserDialog : public KDialogBase
{
	TQ_OBJECT

public:
	IngredientParserDialog( const UnitList &units, TQWidget* parent = 0, const char* name = 0 );
	~IngredientParserDialog();
	
	IngredientList ingredients() const { return m_ingList; }

protected:
	TQLabel* textLabel1;
	TQLabel *previewLabel;
	TQTextEdit* ingredientTextEdit;
	KPushButton* parseButton;
	TDEListView* previewIngView;
	TQPushButton* buttonGroup;

protected slots:
	virtual void accept();
	void parseText();
	void removeIngredient();

	//Set Header button slot
	virtual void convertToHeader();
	virtual void languageChange();

private:
	void convertToHeader( const TQPtrList<TQListViewItem> &items );

	UnitList m_unitList;
	IngredientList m_ingList;
};

#endif // INGREDIENTPARSERDIALOG_H
