// Author: Mattias Fliesberg (C) Copyright 2006
// Copyright: See COPYING file that comes with this distribution
//

#ifndef XSPFPlaylist_H
#define XSPFPlaylist_H

class AtomicString;

#include <tqstring.h>
#include <tqtextstream.h>
#include <tqdom.h>
#include <tqdatetime.h>
#include <tqfile.h>
#include <tqvaluelist.h>

#include <kurl.h>

/**
 * @class XSPFPlaylist
 * @author Mattias Fliesberg
 */

typedef struct {
    KURL location;
    TQString identifier;
    TQString title;
    AtomicString creator;
    TQString annotation;
    KURL info;
    KURL image;
    AtomicString album;
    uint trackNum;
    uint duration;
    KURL link;
//     meta,
//     extension
} XSPFtrack;

typedef TQValueList < XSPFtrack > XSPFtrackList;

class XSPFPlaylist : public TQDomDocument
{
public:
    XSPFPlaylist();
    XSPFPlaylist( TQTextStream &stream );

public:
    /* convenience functions */
    TQString title();
    TQString creator();
    TQString annotation();
    KURL info();
    KURL location();
    TQString identifier();
    KURL image();
    TQDateTime date();
    KURL license();
    KURL::List attribution();
    KURL link();
//    meta();
//    extension();

    void setTitle( TQString title );
    void setCreator( TQString creator );
    void setAnnotation( TQString annotation );
    void setInfo( KURL info );
    void setLocation( KURL location );
    void setIdentifier( TQString identifier );
    void setImage( KURL image );
    void setDate( TQDateTime date );
    void setLicense( KURL license );
    void setAttribution( KURL attribution, bool append = true );
    void setLink( KURL link );
    void setTrackList( XSPFtrackList trackList, bool append = false );
//    meta();
//    extension();

    XSPFtrackList trackList();


private:
    bool loadXSPF( TQTextStream& );
};

#endif // XSPFPlaylist_H




