/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "BaseToolBox.h"

#include "BaseTool.h"
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>


namespace Rosegarden
{

BaseToolBox::BaseToolBox(TQWidget* parent)
        : TQObject(parent),
        m_tools(17,  // default size, from the TQt docs
                false) // but we want it to be case insensitive
{
    //m_tools.setAutoDelete(true);
}

BaseTool* BaseToolBox::getTool(const TQString& toolName)
{
    BaseTool* tool = m_tools[toolName];

    if (!tool) tool = createTool(toolName);

    connect(tool, TQ_SIGNAL(showContextHelp(const TQString &)),
            this, TQ_SIGNAL(showContextHelp(const TQString &)));
    
    return tool;
}

}
#include "BaseToolBox.moc"
