/***************************************************************************
    begin                : Mar 12 2007
    copyright            : 2007 by Holger Danielsson
    email                : holger.danielsson@versanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KILEEXTENSIONS_H
#define KILEEXTENSIONS_H

#include "kileconstants.h"

#include <tqstring.h>
#include <tqstringlist.h>

#include <kurl.h>

namespace KileDocument 
{

class Extensions
{
public:
	Extensions();
	~Extensions() {}

	enum { LATEX_EXT_DOC=1,  LATEX_EXT_PKG=2,  LATEX_EXT_BIB=4, LATEX_EXT_IMG=8,  LATEX_EXT_MP=16, LATEX_EXT_JS=32, LATEX_EXT_PROJ=64 };

	TQString latexDocuments() { return m_documents; }
	TQString latexPackages() { return m_packages; }
	TQString bibtex() { return m_bibtex; }
	TQString images() { return m_images; }
	TQString metapost() { return m_metapost; }

	TQString latexDocumentDefault() { return m_latexDefault; }
	TQString bibtexDefault() { return m_bibtexDefault; }
	TQString metapostDefault() { return m_metapostDefault; }

	TQString latexDocumentFileFilter() { return fileFilter(LATEX_EXT_DOC); }
	TQString latexPackageFileFilter() { return fileFilter(LATEX_EXT_PKG); }
	TQString bibtexFileFilter() { return fileFilter(LATEX_EXT_BIB); }
	TQString imageFileFilter() { return fileFilter(LATEX_EXT_IMG); }
	TQString metapostFileFilter() { return fileFilter(LATEX_EXT_MP); }
	TQString scriptFileFilter() { return fileFilter(LATEX_EXT_JS); }
	TQString projectFileFilter() { return fileFilter(LATEX_EXT_PROJ); }
	
	bool isTexFile(const TQString &fileName) const;
	bool isTexFile(const KURL &url) const { return isTexFile(url.fileName()); }
	bool isBibFile(const TQString &fileName) const;	
	bool isBibFile(const KURL &url) const { return isBibFile(url.fileName()); }
	bool isScriptFile(const TQString &fileName) const;
	bool isScriptFile(const KURL & url) const { return isScriptFile(url.fileName()); }
	bool isProjectFile(const TQString &fileName) const;
	bool isProjectFile(const KURL &url) const { return isProjectFile(url.fileName()); }
	
	bool isLatexDocument(const TQString &ext) const { return validExtension(ext,m_documents); }
	bool isLatexPackage(const TQString &ext) const { return validExtension(ext,m_packages); }
	bool isImage(const TQString &ext) const { return validExtension(ext,m_images); }

	KileDocument::Type determineDocumentType(const KURL &url) const;
	TQString defaultExtensionForDocumentType(KileDocument::Type type) const;

private:
	TQString m_documents, m_packages;
	TQString m_bibtex, m_metapost;
	TQString m_images, m_script;
	TQString m_project;

	TQString m_latexDefault, m_bibtexDefault;
	TQString m_metapostDefault, m_scriptDefault;
	TQString m_projectDefault;

	bool isBibtex(const TQString &ext) const { return validExtension(ext,m_bibtex); }
	bool isMetapost(const TQString &ext) const { return validExtension(ext,m_metapost); }
	bool isScript(const TQString &ext) const { return validExtension(ext,m_script); }
	bool isProject(const TQString &ext) const { return validExtension(ext,m_project); }
	bool validExtension(const TQString &ext, const TQString &extensions) const;

	TQString fileFilter(uint type);
};

}

#endif
