#include "colorpicker.h"
#include <tqcolor.h>
#include <tqlayout.h>
#include <tqslider.h>
#include <tqspinbox.h>

ColorPicker::ColorPicker(TQWidget* parent, const char* name) : TQGroupBox( parent, name){
//    box = new TQGroupBox(parent);
//     setFrameShape(TQFrame::GroupBoxPanel);
//     setFrameShadow(TQFrame::Sunken);
    setColumnLayout(0, TQt::Vertical );
    layout()->setSpacing( 6 );
    layout()->setMargin( 11 );
    
    TQVBoxLayout *vLayout = new TQVBoxLayout(layout());
//     gridLayout->setAlignment( TQt::AlignTop );
    
    TQHBoxLayout *redLayout = new TQHBoxLayout();
    redSlider = new TQSlider(0, 255, 1, 0, TQt::Horizontal, this, "redSlider");
    redLayout->addWidget(redSlider);
    
    redValue = new TQSpinBox(0,255,1,this);
    redValue->setValue(0);
    redLayout->addWidget(redValue);
    
    vLayout->addLayout(redLayout);
    
    TQHBoxLayout *greenLayout = new TQHBoxLayout();
    greenSlider = new TQSlider(0, 255, 1, 0, TQt::Horizontal, this, "greenSlider");
    greenLayout->addWidget(greenSlider);
    
    greenValue = new TQSpinBox(0,255,1,this);
    greenValue->setValue(0);
    greenLayout->addWidget(greenValue);
    
    vLayout->addLayout(greenLayout);
    
    TQHBoxLayout *blueLayout = new TQHBoxLayout();
    blueSlider = new TQSlider(0, 255, 1, 0, TQt::Horizontal, this, "blueSlider");
    blueLayout->addWidget(blueSlider);
    
    blueValue = new TQSpinBox(0,255,1,this);
    blueValue->setValue(0);
    blueLayout->addWidget(blueValue);
    
    vLayout->addLayout(blueLayout);
    
//     resize( TQSize(350, 100).expandedTo(minimumSizeHint()) );
    
    //connections
    connect(redSlider, TQ_SIGNAL(valueChanged (int)), this, TQ_SLOT(setRed(int)));
    connect(greenSlider, TQ_SIGNAL(valueChanged (int)), this, TQ_SLOT(setGreen(int)));
    connect(blueSlider, TQ_SIGNAL(valueChanged (int)), this, TQ_SLOT(setBlue(int)));
    connect(redValue, TQ_SIGNAL(valueChanged (int)), this, TQ_SLOT(setRed(int)));
    connect(greenValue, TQ_SIGNAL(valueChanged (int)), this, TQ_SLOT(setGreen(int)));
    connect(blueValue, TQ_SIGNAL(valueChanged (int)), this, TQ_SLOT(setBlue(int)));
}

ColorPicker::~ColorPicker(){
}

void ColorPicker::setColor(TQColor color){
    redSlider->blockSignals(true);
    redSlider->setValue( color.red() );
    redSlider->blockSignals(false);
    redValue->blockSignals(true);
    redValue->setValue(redSlider->value());
    redValue->blockSignals(false);
    greenSlider->blockSignals(true);
    greenSlider->setValue( color.green() );
    greenSlider->blockSignals(false);
    greenValue->blockSignals(true);
    greenValue->setValue(greenSlider->value());
    greenValue->blockSignals(false);
    blueSlider->blockSignals(true);
    blueSlider->setValue( color.blue() );
    blueSlider->blockSignals(false);
    blueValue->blockSignals(true);
    blueValue->setValue(blueSlider->value());
    blueValue->blockSignals(false);
    emit colorChanged(color);
}

void ColorPicker::setRed(int red){
    redSlider->blockSignals(true);
    redSlider->setValue( red );
    redSlider->blockSignals(false);
    redValue->blockSignals(true);
    redValue->setValue(red);
    redValue->blockSignals(false);
    emit colorChanged(TQColor(red, greenSlider->value(), blueSlider->value()));
}

void ColorPicker::setGreen(int green){
    greenSlider->blockSignals(true);
    greenSlider->setValue( green );
    greenSlider->blockSignals(false);
    greenValue->blockSignals(true);
    greenValue->setValue(green);
    greenValue->blockSignals(false);
    emit colorChanged(TQColor(redSlider->value(), green, blueSlider->value()));
}

void ColorPicker::setBlue(int blue){
    blueSlider->blockSignals(true);
    blueSlider->setValue( blue );
    blueSlider->blockSignals(false);
    blueValue->blockSignals(true);
    blueValue->setValue(blue);
    blueValue->blockSignals(false);
    emit colorChanged(TQColor(redSlider->value(), greenSlider->value(), blue));
}

TQColor ColorPicker::Color(){
    return TQColor(redSlider->value(), greenSlider->value(), blueSlider->value());
}

void ColorPicker::reset(){
    setColor(color_);
}

void ColorPicker::init(){
    color_ = Color();
}

#include "colorpicker.moc"
