/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATERESULTDISPLAY_H
#define QALCULATERESULTDISPLAY_H

#include <tqtextbrowser.h>

class TQPopupMenu;
class TQToolTip;
class MathStructure;

/**
@author Niklas Knutsson
*/
class QalculateResultDisplay : public TQTextBrowser {

	TQ_OBJECT

public:

	QalculateResultDisplay(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateResultDisplay();

	TQPopupMenu *createPopupMenu(const TQPoint & pos);
	
	TQToolTip *tooltip;
	const MathStructure *m_under_pointer;
	TQString name_under_pointer;
	TQPoint curpos;
	
	TQSize minimumSizeHint() const;
	TQSize sizeHint() const;
	
	void setRightMargin(int);
	
public slots:

	void onAnchorClicked(const TQString&, const TQString&);
	void showParsedExpression();

private slots:

	void paletteChanged();
	void setSource(const TQString &) {}
	void showInfo();
	void editVector();
	void editMatrix();
	void onDoubleClicked(int, int);
	void displayEngineering();
	void displayScientific();
	void displayNormal();

protected:

	void virtual_hook(int id, void* data);
	void focusInEvent(TQFocusEvent *fe);
	void focusOutEvent(TQFocusEvent *fe);
	void keyPressEvent(TQKeyEvent *e);
    
};

#endif
